import unittest 
import json
import jsonschema
from jsonschema import validate

class TestValidate(unittest.TestCase):


    schema_path='./schema/ILDS_emission_schema.json'
    test_data_folder='../test_data'

    def setUp(self):
        #load the json schema to be used for validation
        with open(self.schema_path, 'r') as f:
            schema_data = f.read()
        self.schema=json.loads(schema_data)
        return super().setUp()

    def test_validate_valid_file(self):
        valid_file='./test_data/valid_file.json'
        try:
            with open(valid_file, 'r') as f:
                file_data = f.read()
            json_data=json.loads(file_data)
            validate(instance=json_data, schema=self.schema)
        except jsonschema.exceptions.ValidationError as err:
            self.fail('Error in validating a file that should be valid:{}, error:{}'.format(valid_file,err))
    
    def test_validate_invalid_missin_src_entity(self):
        '''
        Test that validation should fail when no source entity is specified
        '''
        valid_file='./test_data/invalid_missing_required_src_entity_data.json'
        try:
            with open(valid_file, 'r') as f:
                file_data = f.read()
            json_data=json.loads(file_data)
            validate(instance=json_data, schema=self.schema)
        except jsonschema.exceptions.ValidationError as err:
            print ('Error in validating a file that should be valid:{}, error:{}'.format(valid_file,err))
            return True
        self.fail('Test should fail as data is missing source entity')


if __name__ == '__main__':
    unittest.main()