<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:mprml="http://www.epim.no/schemas/mprml/1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:epim="xalan://com.epim.ep.standards.XSDDateHelper">

	<xsl:output method="html" encoding="UTF-8" indent="yes"/>
	<xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyzæåø'" />
	<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÆÅØ'" />
	<xsl:variable name="USE_TIMEZONE_CONVERSION">true</xsl:variable><!--if set to true will try to convert time data using external library-->
	<xsl:param name="EXT_INCL_ALL_SECTIONS">0</xsl:param><!-- this parameter can be set from the outside if needed, and if set to "1" it will show all sections independent of if they have data or not-->
	<xsl:param name="EXT_SHOW_ALL_COLUMNS">0</xsl:param><!-- this parameter can be set from the outside if needed and if set to "1" it will show all columns independent if they have data or not --> 
	<xsl:param name="EXT_SHOW_COLOR_ENCODING">false</xsl:param><!-- this parameter can be set from the outside if needed and if set to "true" it will show color encodings for recommended and optional columns-->

	<xsl:param name="CSS_ROOT"></xsl:param><!-- this parameter can be set from the outside if needed and if null will use CSS from cdnjs.cloudflare.com-->
	<xsl:param name="CSS_ROOT_PATH">
		<xsl:choose>
			<xsl:when test="$CSS_ROOT!=''"><xsl:value-of select="$CSS_ROOT"/></xsl:when>
			<xsl:otherwise>https://cdnjs.cloudflare.com/ajax/libs/bulma/0.7.1/css/</xsl:otherwise>
		</xsl:choose>
	</xsl:param>

	<!-- start of styling parameters for tables-->
	<xsl:param name="REPORT_INFO_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param> <!--used to control style of reportingo tables-->
	<xsl:param name="PROD_WELLS_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param> <!--used to control style of production wells tables-->
	<xsl:param name="INJ_WELLS_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param> <!--used to control style of inj wells tables-->
	<xsl:param name="CONSUME_FUEL_FLARE_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param> <!--used to control style of consume fuel and flare gas tables-->
	<xsl:param name="CONSUME_OTHER_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param> <!--used to control style of consume other tables-->

	<xsl:param name="ACTIVITY_COMMENTS_PRODUCTION_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param><!--used to control style of production comments table-->
	<xsl:param name="EXPORT_INFORMATION_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param><!--used to control style of export information table-->
	<xsl:param name="INVENTORY_INFORMATION_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param><!--used to control style of inventory information table-->
	<xsl:param name="IMPORT_INFORMATION_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param><!--used to control style of import information table-->
	<xsl:param name="PRODUCTION_INFORMATION_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param><!--used to control style of production information table-->
	<xsl:param name="INJECTION_INFORMATION_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param><!--used to control style of in injection information table-->
	<xsl:param name="GASLIFT_INFORMATION_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param><!--used to control output styling of gaslift table-->
	<xsl:param name="WATER_INFORMATION_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param><!--used to control output styling of water information table-->
	<xsl:param name="PROD_WELLTEST_INFORMATION_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param><!--used to control output styling for prod well test table-->
	<xsl:param name="INJ_WELLTEST_INFORMATION_TABLE_CLASS">table is-striped  dpr20-report-table</xsl:param><!--used to control output styling for inj well test table-->

	<!--end of table stylings-->

    <!--params below are used a table headers for common table columns-->
    <xsl:param name="MONTH_TO_DATE_HEADER">Mtd</xsl:param><!--text to use for month to date header-->
    <xsl:param name="YEAR_TO_DATE_HEADER">Ytd</xsl:param><!--text to use for year to date header-->
	<xsl:param name="QUALIFIER_HEADER">Qualifier</xsl:param><!--text to use for flow qualifier header-->
	<xsl:param name="ASSET_HEADER">Asset</xsl:param><!--text to use for asset (facility name) header-->
	<xsl:param name="PRODUCT_HEADER">Product</xsl:param><!--text to use for product header-->
	<xsl:param name="UOM_HEADER">UoM</xsl:param><!--text to use for uom header-->
	<xsl:param name="DAY_HEADER">Day</xsl:param><!--text to use for day header-->
	<xsl:param name="NAME_HEADER">Name</xsl:param><!--text to use for name header-->
	<xsl:param name="FLOW_KIND_HEADER">Kind</xsl:param><!--text to use for flow kind header-->
	<xsl:param name="OIL_IN_WATER_HEADER">Oil in water</xsl:param><!--text to use for water in oil header-->
	<xsl:param name="PRODUCT_NAME">Product name</xsl:param><!--text used for product name header if product name exists-->
	
	<!--below is parameters that is used to control the over all flow for the report generation e.g. showing hiding all columns-->
	
	<xsl:param name="INCLUDE_ALL_SECTIONS">
			<xsl:choose>
					<xsl:when test="$EXT_INCL_ALL_SECTIONS!=''"><xsl:value-of select="$EXT_INCL_ALL_SECTIONS"/></xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
	</xsl:param><!--if set to 1 it will include all section even though they have no asssociated data-->
	<xsl:param name="SHOW_ALL_COLUMNS">
		<xsl:choose>
			<xsl:when test="$EXT_SHOW_ALL_COLUMNS!=''"><xsl:value-of select="$EXT_SHOW_ALL_COLUMNS"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:param><!--if set to 1 it will show all columns even though there is no data there-->
   <!--the following are used to generate color encodings if needed for hightlighting of opt, recommended and required columns-->	
	<xsl:variable name="COLOR_RECOMMENDED_COL">#209cee</xsl:variable><!--color to be used as background for recommended columns-->
	<xsl:variable name="COLOR_OPTIONAL_COL">#00d1b2</xsl:variable><!-- color to be used as background for optional columns-->
	<xsl:variable name="SHOW_COLOR_ENCODING">
		<xsl:choose>
			<xsl:when test="$EXT_SHOW_COLOR_ENCODING!=''"><xsl:value-of select="$EXT_SHOW_COLOR_ENCODING"/></xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable><!-- if set to true will color encode required, optional and recommended columns-->
	<xsl:template match="/">
	    <xsl:text disable-output-escaping='yes'>&lt;!DOCTYPE html&gt;</xsl:text>
		<html>
			<head>
					<meta charset="utf-8"/>
					<meta name="viewport" content="width=device-width, initial-scale=1"/>
				    <link rel="stylesheet" href="{$CSS_ROOT_PATH}bulma.css.map"></link>
					<link rel="stylesheet" href="{$CSS_ROOT_PATH}bulma.min.css"></link>
				  <style>
				  /* set the page size to be A4 at a maximum
*/


/*html,body{
    height:297mm;
    width:210mm;
}*/

@media print and (color)
{*
{
    -webkit-print-color-adjust:exact;
   print-color-adjust:exact;
    tbody {
                page-break-inside: avoid;
            }
            thead {
                display: table-header-group;
                padding-top: 100px;
            }
}}

/*table, tr, td, th, tbody, thead, tfoot,div { page-break-inside: avoid !important; }*/


.dpr20-report-subsection .columns{
    background:#FFFF;
    text-align:center;
    border-radius:4px;
    font-size:1rem;
    text-align:center;
    //height:20px;
    line-height:20px;
    margin-bottom:.75rem;
    letter-spacing:.1rem;
}

.dpr20-report-grid .columns{
    background:#BBB;
    text-align:center;
    border-radius:4px;
    font-size:1rem;
    text-align:center;
    //height:30px;
    //line-height:30px;
    //margin-bottom:.75rem;
    //letter-spacing:.1rem;
}




.dpr20-report-grid .column{
    background:#BBB;
    text-align:center;
    border-radius:4px;
    font-size:1rem;
    //height:30px;
    //line-height:30px;
   // margin-bottom:.75rem;
    //letter-spacing:.1rem;
    display:flex;

    flex-direction:column;
    justify-content:center;
    -ms-justify-content:center;
    /*display: -ms-flexbox;*/
}

.footer{
    height:15px;
    position:absolute;
    width:100%;
    bottom:0;
    overflow:hidden;
    font-family:Arial;
    font-size:8px;
    text-decoration:none;
    font-style:italic;
    color:#000000;
    text-align:left;
}


.DPR20-SubReportHeader{
    font-family:Arial Black;
    font-size:12px;
}

.DPR20-ReportHeader{
    font-family:Arial Black;
    font-size:16px;
}

.DPR20-ReportSectionTxt{
    font-family:Arial Black;
    font-size:14px;
}

.dpr20-report-table .ColHead{
    font-family:Arial Black;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:center;
}
 /*controls the width of the time column in activity comments table*/
.dpr20-report-table .ColHeadCommentTime{
    font-family:Arial Black;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    width:120px;
    text-align:center;
}

/*controls the width of the asset column in activity comments table*/
.dpr20-report-table .ColHeadCommentAsset{
    font-family:Arial Black;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    width:120px;
    text-align:center;
}




/*controls header styling for recommended tables*/
.dpr20-report-table .ColHeadRec{
    font-family:Arial Black;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:center;
    <xsl:if test="$SHOW_COLOR_ENCODING='true'">
		background: <xsl:value-of select="$COLOR_RECOMMENDED_COL"/>;
    </xsl:if>
}

/*controls header styling for optional tables*/
.dpr20-report-table .ColHeadOpt{
    font-family:Arial Black;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:center;
   
    <xsl:if test="$SHOW_COLOR_ENCODING='true'">
		background: <xsl:value-of select="$COLOR_OPTIONAL_COL"/>;
    </xsl:if>
}

.dpr20-report-table .ColHeadUom{
    font-family:Arial;
    font-size:9px;
    font-style:italic;
    text-decoration:none;
    color:#000000;
    text-align:center;
}
/*control header uom table styling for rec table cells*/
.dpr20-report-table .ColHeadUomRec{
    font-family:Arial;
    font-size:9px;
    font-style:italic;
    text-decoration:none;
    color:#000000;
    text-align:center;
   <xsl:if test="$SHOW_COLOR_ENCODING='true'">
		background: <xsl:value-of select="$COLOR_RECOMMENDED_COL"/>;
    </xsl:if>
}
/*control header uom table styling for optional table cells*/
.dpr20-report-table .ColHeadUomOpt{
    font-family:Arial;
    font-size:9px;
    font-style:italic;
    text-decoration:none;
    color:#000000;
    text-align:center;
    <xsl:if test="$SHOW_COLOR_ENCODING='true'">
		background: <xsl:value-of select="$COLOR_OPTIONAL_COL"/>;
    </xsl:if>
}

/*used for styling number data columns*/
.dpr20-report-table .ColValue{
    font-family:Arial;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:right;
}
/*used for styling text data columns*/
.dpr20-report-table .ColValueTxt{
    font-family:Arial;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:left;
}

/*used for styling recommended text data columns*/
.dpr20-report-table .ColValueTxtRec{
    font-family:Arial;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:left;
    <xsl:if test="$SHOW_COLOR_ENCODING='true'">
		background: <xsl:value-of select="$COLOR_RECOMMENDED_COL"/>;
    </xsl:if>
}

/*used for styling optional text data columns*/
.dpr20-report-table .ColValueTxtOpt{
    font-family:Arial;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:left;
     <xsl:if test="$SHOW_COLOR_ENCODING='true'">
		background: <xsl:value-of select="$COLOR_OPTIONAL_COL"/>;
    </xsl:if>
}

/*controls cell value table styling for recommended cells*/
.dpr20-report-table .ColValueRec{
    font-family:Arial;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:right;
    <xsl:if test="$SHOW_COLOR_ENCODING='true'">
		background: <xsl:value-of select="$COLOR_RECOMMENDED_COL"/>;
    </xsl:if>
}

/*controls cell value table styling for optional cells*/
.dpr20-report-table .ColValueOpt{
    font-family:Arial;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:right;
    <xsl:if test="$SHOW_COLOR_ENCODING='true'">
		background: <xsl:value-of select="$COLOR_OPTIONAL_COL"/>;
    </xsl:if>
}

.dpr20-report-table .ColHeadRowOriented{
    font-family:Arial Black;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:left;

}


.dpr20-report-table .ColValueWrapped{
    font-family:Arial;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:left;
    white-space:pre-wrap;
}

/*controls cell value table wrapped styling for recommended cells*/
.dpr20-report-table .ColValueWrappedRec{
    font-family:Arial;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:right;
    <xsl:if test="$SHOW_COLOR_ENCODING='true'">
		background: <xsl:value-of select="$COLOR_RECOMMENDED_COL"/>;
    </xsl:if>
}

/*controls cell value table wrapped styling for optional cells*/
.dpr20-report-table .ColValueWrappedOpt{
    font-family:Arial;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:right;
     <xsl:if test="$SHOW_COLOR_ENCODING='true'">
		background: <xsl:value-of select="$COLOR_OPTIONAL_COL"/>;
    </xsl:if>
}



/*Set the css for the text data field containing the actual text comments for sections containing e.g. comments data such as summary of activities*/
.dpr20-report-table .TextData{

    white-space:pre-wrap;
    font-family:Arial;
    font-size:11px;
    text-decoration:none;
    color:#000000;
    text-align:left;
}
/*Set the css for the text header for sections containing e.g. comments data such as summary of activities*/
.dpr20-report-table .TextHeader{
    background:#BBB;
    border-radius:4px;
    font-size:1rem;
    height:30px;
    line-height:30px;
    margin-bottom:.75rem;
    letter-spacing:.1rem;
    font-family:Arial Black;
    font-size:12px;
}
				  
				  
				  
				  </style>
				
			</head>
			<body>
				
				   <xsl:if test="$SHOW_COLOR_ENCODING='true'">
					    <div class="container">
						 <xsl:call-template name="OUTPUT_COLOR_ENCODING"/>
				     </div>
				   </xsl:if>
				  
						<div class="container">
							
									<xsl:call-template name="BUILD_HEADER"/>
								   <xsl:call-template name="BUILD_REPORT_INFO"/>
								 <br></br>
						</div>
				       
				   <xsl:if test="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='export'] or $INCLUDE_ALL_SECTIONS=1">
					
							<div class="container">
								
								<xsl:call-template name="BUILD_EXPORT_INFORMATION"/>
								
								<br></br>
							</div>
					       
				    </xsl:if>
				
					<xsl:if test="//mprml:flow[mprml:kind='production'] or $INCLUDE_ALL_SECTIONS=1">
					<div class="container">
						
						<xsl:call-template name="BUILD_PRODUCTION_INFORMATION"/>
						
						<br></br>
					</div>
				   </xsl:if>
				
				    <xsl:if test="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='import']  or $INCLUDE_ALL_SECTIONS=1">
					<div class="container">
						
						<xsl:call-template name="BUILD_IMPORT_INFORMATION"/>
						<br></br>
						
					</div>
				    </xsl:if>
				
					<xsl:if test="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='inventory']  or $INCLUDE_ALL_SECTIONS=1">
					<div class="container">
						
						<xsl:call-template name="BUILD_INVENTORY_INFORMATION"/>
						
						<br></br>
					</div>
					</xsl:if>
				
				
					<xsl:if test="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='injection']  or $INCLUDE_ALL_SECTIONS=1">
					<div class="container">
						
						<xsl:call-template name="BUILD_INJECTION_INFORMATION"/>
						
						<br></br>
					</div>
				    </xsl:if>
				
					<xsl:if test="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='gas lift']  or $INCLUDE_ALL_SECTIONS=1">
					<div class="container">
						
						<xsl:call-template name="BUILD_GASLIFT_INFORMATION"/>
						<br></br>
						
					</div>
					</xsl:if>
				
				    <xsl:if test="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='production'][mprml:product/mprml:kind='water']  or $INCLUDE_ALL_SECTIONS=1">
					<div class="container">
						
						<xsl:call-template name="BUILD_WATER_INFORMATION"/>
						<br></br>
						
					</div>
				    </xsl:if>
				
				   <xsl:if test="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='consume' or mprml:kind='consume - fuel' or mprml:kind='consume - flare']  or $INCLUDE_ALL_SECTIONS=1">
					<div class="container">
						
						<xsl:call-template name="BUILD_CONSUME_INFORMATION"/>
						<br></br>
						
					</div>
				    </xsl:if>
				
					<div class="container">
						
						<xsl:call-template name="BUILD_WELL_INFORMATION"/>
						<br></br>
						
					</div>
				
				
			        <xsl:if test="//mprml:object[@xsi:type='obj_wellTest'] or $INCLUDE_ALL_SECTIONS=1">
					<div class="container">
						
						<xsl:call-template name="BUILD_WELLTEST_INFORMATION"/>
						<br></br>
						
					</div>
				    </xsl:if>
				    <xsl:if test="//mprml:object[@xsi:type='obj_productionOperation'] or $INCLUDE_ALL_SECTIONS=1">
					<div class="container">
						
						<xsl:call-template name="BUILD_ACTIVITY_INFORMATION"/>
						<br></br>
						
					</div>
				   </xsl:if>
				
			</body>
		</html>
	</xsl:template>
	
    <xsl:template name="OUTPUT_COLOR_ENCODING">
	   <div class="columns">
		   <div class="column"/>
	   </div>
	    <xsl:call-template name="OUTPUT_SECTION"><xsl:with-param name="SECTION_TXT">Column color encoding overview</xsl:with-param></xsl:call-template>


	   <div class="columns">
		  <div class="column">
			 <span class="tag is-white is-large">Required</span>
		  </div>
		  <div class="column">
		    <span class="tag is-info is-large">Recommended</span>
	  </div>
		  <div class="column">
			  <span class="tag is-primary is-large">Optional</span>

	  </div>
		  <div class="column is-half">
		  </div>
   
    </div>
   </xsl:template>		
	
	<xsl:template name="OUTPUT_FOOTER">
			<footer class="footer">
				Footer 
			</footer>
	</xsl:template>
	
	<xsl:template name="OUTPUT_DTIM">
		<xsl:param name="DTIM"/>
		<xsl:choose>
			<xsl:when test="$DTIM!=''">
				<xsl:choose>
					<xsl:when test="$USE_TIMEZONE_CONVERSION='true'"><xsl:value-of select="epim:DateTime2LocalTime($DTIM,'YYYY-MM-dd HH:mm')"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="concat(substring-before(substring($DTIM, 0,17), 'T'), ' ', substring-after(substring($DTIM, 0,17), 'T'))"/></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
		<xsl:otherwise>-</xsl:otherwise>		
		</xsl:choose>
		
	</xsl:template>
	
	<xsl:template name="OUTPUT_DTIM_TIME_ONLY">
		<xsl:param name="DTIM"/>
		<xsl:choose>
			<xsl:when test="$DTIM!=''">
				<xsl:choose>
					<xsl:when test="$USE_TIMEZONE_CONVERSION='true'"><xsl:value-of select="epim:DateTime2LocalTime($DTIM,'HH:mm')"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="substring-after(substring($DTIM, 0,17), 'T')"/></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>-</xsl:otherwise>
			</xsl:choose>
	</xsl:template>
	
     <xsl:template name="BUILD_UOM_FOR_VOLUME">
		<xsl:param name="UNIT"/>
		<xsl:param name="TEMP"/>
		<xsl:param name="PRES"/>
		
		<xsl:choose>
			<xsl:when test="$UNIT='m3' and $TEMP='15' and $PRES='1'">Sm<sup>3</sup></xsl:when>
			<xsl:when test="$UNIT='m3' and $TEMP='0' and $PRES='0'">Nm<sup>3</sup></xsl:when>
			<xsl:otherwise><xsl:value-of select="$UNIT"/></xsl:otherwise>

		</xsl:choose>
    </xsl:template>	
	
     <xsl:template name="BUILD_UOM_FOR_DENSITY">
		<xsl:param name="UNIT"/>
		<xsl:param name="TEMP"/>
		<xsl:param name="PRES"/>
		
		<xsl:choose>
			<xsl:when test="$UNIT='kg/m3' and $TEMP='15' and $PRES='1'">kg/Sm<sup>3</sup></xsl:when>
			<xsl:when test="$UNIT='kg/m3' and $TEMP='0' and $PRES='0'">kg/Nm<sup>3</sup></xsl:when>
			<xsl:otherwise><xsl:value-of select="$UNIT"/></xsl:otherwise>

		</xsl:choose>
    </xsl:template>		
	
    <xsl:template name="BUILD_REPORT_INFO">
		<!--<div class="columns is-gapless is-narrow is-multiline">-->
		<div class="columns">
			    <div class="column"><xsl:call-template name="REPORT_INFO_TABLE_DATA"/></div>
				
	    </div>
    
    </xsl:template>	
    
    <xsl:template name="BUILD_FLOW_NAME">
		<xsl:param name="NAME"/>
		<xsl:param name="KIND"/>
		<xsl:param name="FLOWQUALIFIER"/>
	    <xsl:variable name="LOWERCASE_NAME"><xsl:value-of select="translate(substring($NAME,1,string-length($NAME)),$uppercase,$smallcase)"/></xsl:variable>
	    <xsl:variable name="FIRST_LETTER"><xsl:value-of select="substring($NAME,1,1)"/></xsl:variable>
	    
	    <xsl:value-of select="concat($NAME,' ',$KIND,' ',$FLOWQUALIFIER)"/>
    </xsl:template>
	
	
	<xsl:template name="BUILD_WELLTEST_INFORMATION">
		<xsl:call-template name="OUTPUT_SECTION"><xsl:with-param name="SECTION_TXT">Welltest Information</xsl:with-param></xsl:call-template>
		<xsl:call-template name="OUTPUT_SUB_SECTION"><xsl:with-param name="SECTION_SUB_TXT">Production test</xsl:with-param></xsl:call-template>
		<div class="columns dpr20-report-table">
			<div class="column">
				<xsl:call-template name="OUTPUT_PROD_WELLTEST_INFORMATION_TABLE"/>
			</div>
		</div>
		<xsl:if test="//mprml:injectionTest">
		<xsl:call-template name="OUTPUT_SUB_SECTION"><xsl:with-param name="SECTION_SUB_TXT">Injection test</xsl:with-param></xsl:call-template>
		<div class="columns dpr20-report-table">
			<div class="column">
				<xsl:call-template name="OUTPUT_INJ_WELLTEST_INFORMATION_TABLE"/>
			</div>
		</div>
		</xsl:if>

	</xsl:template>
	<xsl:template name="OUTPUT_PROD_WELLTEST_INFORMATION_TABLE">
		
		<table id="exportInformationTable">
			<xsl:attribute name="class"><xsl:value-of select="$PROD_WELLTEST_INFORMATION_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHeadRec">Name</th>
					<th class="ColHeadRec">Test time</th>
					<th class="ColHeadOpt">Last valid test</th>
					<th class="ColHeadRec">Duration</th>
					<th class="ColHeadRec">Choke</th>
					<th class="ColHeadRec">WHP</th>
					<th class="ColHeadRec">WHT</th>
					<th class="ColHeadRec">Oil</th>
					<th class="ColHeadRec">Gas</th>
					<th class="ColHeadRec">Water</th>
					<th class="ColHeadRec">GL</th>
					<th class="ColHeadOpt">GoR</th>
					
				</tr>
				<tr>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomOpt"></th>
					<th class="ColHeadUomRec"><xsl:value-of select="//mprml:productionTest/mprml:testDuration/@uom[1]"/></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"><xsl:value-of select="//mprml:productionTest/mprml:wellheadData/mprml:flowingPressure/@uom[1]"/></th>
					<th class="ColHeadUomRec"><xsl:value-of select="//mprml:productionTest/mprml:wellheadData/mprml:temperature/@uom[1]"/></th>
					<th class="ColHeadUomRec"><xsl:value-of select="//mprml:productionTest/mprml:productionTestResults/mprml:oilRate/mprml:fluidRateStdTempPres/@uom[1]"/></th>
					<th class="ColHeadUomRec"><xsl:value-of select="//mprml:productionTest/mprml:productionTestResults/mprml:gasRate/mprml:fluidRateStdTempPres/@uom[1]"/></th>
					<th class="ColHeadUomRec"><xsl:value-of select="//mprml:productionTest/mprml:productionTestResults/mprml:waterRate/mprml:fluidRate/@uom[1]"/></th>
					<th class="ColHeadUomRec"><xsl:value-of select="//mprml:productionTest/mprml:wellheadData/mprml:gasLiftRate/mprml:fluidRateStdTempPres/@uom[1]"/></th>
					<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:productionTest/mprml:productionTestResults/mprml:gasOilRatio/@uom"/></th>
					
					
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="//mprml:object[@xsi:type='obj_wellTest'][mprml:productionTest]">
					<tr>
						
						<td class="ColValueTxtRec"><xsl:value-of select="mprml:nameWell"/></td>
						<td class="ColValueTxtRec"><xsl:call-template name="OUTPUT_DTIM"><xsl:with-param name="DTIM" select="mprml:testDate"></xsl:with-param></xsl:call-template></td>
						<td class="ColValueTxtOpt"><xsl:call-template name="OUTPUT_DTIM"><xsl:with-param name="DTIM" select="mprml:lastValidTest"></xsl:with-param></xsl:call-template></td>
						
						<td class="ColValueRec"><xsl:value-of select="mprml:productionTest/mprml:testDuration"/></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:productionTest/mprml:wellheadData/mprml:chokeRelative"/><xsl:text> </xsl:text><xsl:value-of select="mprml:productionTest/mprml:wellheadData/mprml:chokeRelative/@uom"/></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:productionTest/mprml:wellheadData/mprml:flowingPressure"/></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:productionTest/mprml:wellheadData/mprml:temperature"/></td>
						
						<td class="ColValueRec"><xsl:value-of select="mprml:productionTest/mprml:productionTestResults/mprml:oilRate/mprml:fluidRateStdTempPres"/></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:productionTest/mprml:productionTestResults/mprml:gasRate/mprml:fluidRateStdTempPres"/></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:productionTest/mprml:productionTestResults/mprml:waterRate/mprml:fluidRate"/></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:productionTest/mprml:wellheadData/mprml:gasLiftRate/mprml:fluidRateStdTempPres"/></td>
						<td class="ColValueOpt"><xsl:value-of select="mprml:productionTest/mprml:productionTestResults/mprml:gasOilRatio"/></td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	
	<xsl:template name="OUTPUT_INJ_WELLTEST_INFORMATION_TABLE">
		
		<table id="wellTestInjectionTable">
			<xsl:attribute name="class"><xsl:value-of select="$INJ_WELLTEST_INFORMATION_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHeadRec">Name</th>
					<th class="ColHeadRec">Test time</th>
					<th class="ColHeadOpt">Last valid test</th>
					<th class="ColHeadRec">Duration</th>
					<th class="ColHeadRec">Injected fluid</th>
					<th class="ColHeadRec">Choke</th>
					<th class="ColHeadRec">WHP</th>
					<th class="ColHeadRec">Oil</th>
					<th class="ColHeadRec">Gas</th>
					<th class="ColHeadRec">Water</th>
				
					
				</tr>
				<tr>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomOpt"></th>
					<th class="ColHeadUomRec"><xsl:value-of select="//mprml:injectionTest/mprml:testDuration/@uom[1]"/></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"><xsl:value-of select="//mprml:injectionTest/mprml:wellheadFlowingPressure/@uom[1]"/></th>
					<th class="ColHeadUomRec"><xsl:value-of select="//mprml:injectionTest/mprml:injectionTestResults/mprml:oilRate/mprml:fluidRateStdTempPres/@uom[1]"/></th>
					<th class="ColHeadUomRec"><xsl:value-of select="//mprml:injectionTest/mprml:injectionTestResults/mprml:gasRate/mprml:fluidRateStdTempPres/@uom[1]"/></th>
					<th class="ColHeadUomRec"><xsl:value-of select="//mprml:injectionTest/mprml:injectionTestResults/mprml:waterRate/mprml:fluidRate/@uom[1]"/></th>		
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="//mprml:object[@xsi:type='obj_wellTest'][mprml:injectionTest]">
					<tr>
						
						<td class="ColValueTxtRec"><xsl:value-of select="mprml:nameWell"/></td>
						<td class="ColValueTxtRec"><xsl:call-template name="OUTPUT_DTIM"><xsl:with-param name="DTIM" select="mprml:testDate"></xsl:with-param></xsl:call-template></td>
						<td class="ColValueTxtOpt"><xsl:call-template name="OUTPUT_DTIM"><xsl:with-param name="DTIM" select="mprml:lastValidTest"></xsl:with-param></xsl:call-template></td>
						
						<td class="ColValueRec"><xsl:value-of select="mprml:injectionTest/mprml:testDuration"/></td>
						<td class="ColValueTxtRec"><xsl:value-of select="mprml:injectionTest/mprml:InjectedFluid"/></td>
						<td class="ColValueRec"><xsl:choose>
							<xsl:when test="mprml:injectionTest/mprml:chokeRelative"><xsl:value-of select="mprml:injectionTest/mprml:chokeRelative"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="mprml:injectionTest/mprml:chokeOrificeSize"/></xsl:otherwise>
						</xsl:choose> <xsl:choose>
							<xsl:when test="mprml:injectionTest/mprml:chokeRelative"><xsl:value-of select="mprml:injectionTest/mprml:chokeRelative/@uom"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="mprml:injectionTest/mprml:chokeOrificeSize/@uom"/></xsl:otherwise>
						</xsl:choose></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:injectionTest/mprml:wellheadFlowingPressure"/></td>
						
						<td class="ColValueRec"><xsl:value-of select="mprml:injectionTest/mprml:injectionTestResults/mprml:oilRate/mprml:fluidRateStdTempPres"/></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:injectionTest/mprml:injectionTestResults/mprml:gasRate/mprml:fluidRateStdTempPres"/></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:injectionTest/mprml:injectionTestResults/mprml:waterRate/mprml:fluidRate"/></td>
			
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	
	
	
	<xsl:template name="BUILD_WATER_INFORMATION">
		<xsl:call-template name="OUTPUT_SECTION"><xsl:with-param name="SECTION_TXT">Water Information</xsl:with-param></xsl:call-template>
		
		<div class="columns dpr20-report-table">
			<div class="column">
				<xsl:call-template name="OUTPUT_WATER_INFORMATION_TABLE"/>
			</div>
		</div>
	</xsl:template>
	<xsl:template name="OUTPUT_WATER_INFORMATION_TABLE">
		
		<table id="exportInformationTable">
			<xsl:attribute name="class"><xsl:value-of select="$WATER_INFORMATION_TABLE_CLASS"/></xsl:attribute>
			<xsl:variable name="HAS_OIW"><xsl:if test="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='water']/mprml:period[mprml:kind='day']/mprml:componentContent[mprml:kind='oil'] or $SHOW_ALL_COLUMNS=1">true</xsl:if></xsl:variable>
            <xsl:variable name="HAS_PRODUCT_NAME"><xsl:if test="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='production']/mprml:product/mprml:name or $SHOW_ALL_COLUMNS=1">true</xsl:if></xsl:variable>
	
       			
			<thead>
				<tr>
					<th class="ColHeadOpt"><xsl:value-of select="$NAME_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$ASSET_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$FLOW_KIND_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$QUALIFIER_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$PRODUCT_HEADER"/></th>
					<xsl:if test="$HAS_PRODUCT_NAME='true'"><th class="ColHeadOpt"><xsl:value-of select="$PRODUCT_NAME"/></th></xsl:if>
					<th class="ColHeadOpt"><xsl:value-of select="$UOM_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$DAY_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$MONTH_TO_DATE_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$YEAR_TO_DATE_HEADER"/></th>
					<xsl:if test="$HAS_OIW='true'">
						<th class="ColHeadOpt"><xsl:value-of select="$OIL_IN_WATER_HEADER"/></th>
					</xsl:if>
				</tr>
				<xsl:if test="$HAS_OIW='true'">
					<tr>
						<th class="ColHeadUomOpt"></th>
						<th class="ColHeadUomOpt"></th>
						<th class="ColHeadUomOpt"></th>
						<th class="ColHeadUomOpt"></th>
						<th class="ColHeadUomOpt"></th>
						<xsl:if test="$HAS_PRODUCT_NAME='true'"><th class="ColHeadUomOpt"></th></xsl:if>
						<th class="ColHeadUomOpt"></th>
						<th class="ColHeadUomOpt"></th>
						<th class="ColHeadUomOpt"></th>
						<th class="ColHeadUomOpt"></th>
						<xsl:if test="$HAS_OIW='true'">
							<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='water']/mprml:period[mprml:kind='day']/mprml:componentContent[mprml:kind='oil']/mprml:concentration/@uom[1]"/></th>
						</xsl:if>
					</tr>
				</xsl:if>
			</thead>
			<tbody>
				<xsl:for-each select="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='production' or mprml:kind='overboard'][mprml:product/mprml:kind='water']">
					<xsl:sort select="mprml:qualifier"/>
				     <xsl:sort select="mprml:name"/>
				     <xsl:for-each select="mprml:product[mprml:kind='water']">
						<tr>
							
							<td class="ColValueTxtOpt"><xsl:value-of select="../mprml:name"/></td>
							<td class="ColValueTxtOpt"><xsl:value-of select="../../mprml:name"/></td>
							<td class="ColValueTxtOpt"><xsl:value-of select="../mprml:kind"/></td>
							<td class="ColValueTxtOpt"><xsl:value-of select="../mprml:qualifier"/></td>
							<td class="ColValueTxtOpt"><xsl:value-of select="mprml:kind"/></td>
							<xsl:if test="$HAS_PRODUCT_NAME='true'"><td class="ColValueTxtOpt"><xsl:value-of select="mprml:name"/></td></xsl:if>
							<td class="ColValueTxtOpt"><xsl:call-template name="BUILD_UOM_FOR_VOLUME">
									<xsl:with-param name="PRES" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
									<xsl:with-param name="TEMP" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
									<xsl:with-param name="UNIT" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
							</xsl:call-template></td>
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td>
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='month to date']/mprml:volumeValue/mprml:volume"/></td>
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='year to date']/mprml:volumeValue/mprml:volume"/></td>
							<xsl:if test="$HAS_OIW='true'">
								<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day']/mprml:componentContent[mprml:kind='oil']/mprml:concentration"/></td>
							</xsl:if>
						</tr>
					</xsl:for-each>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	
	<xsl:template name="BUILD_GASLIFT_INFORMATION">
		<xsl:call-template name="OUTPUT_SECTION"><xsl:with-param name="SECTION_TXT">Gaslift Information</xsl:with-param></xsl:call-template>
		
		<div class="columns dpr20-report-table">
			<div class="column">
				<xsl:call-template name="OUTPUT_GASLIFT_INFORMATION_TABLE"/>
			</div>
		</div>
	</xsl:template>
	<xsl:template name="OUTPUT_GASLIFT_INFORMATION_TABLE">
		
		<table id="exportInformationTable">
			<xsl:attribute name="class"><xsl:value-of select="$GASLIFT_INFORMATION_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead"><xsl:value-of select="$NAME_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$ASSET_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$QUALIFIER_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$PRODUCT_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$UOM_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$DAY_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$MONTH_TO_DATE_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$YEAR_TO_DATE_HEADER"/></th>
					
				</tr>
			
			</thead>
			<tbody>
				<xsl:for-each select="//mprml:facility[mprml:name/@kind!='wellbore' or mprml:name/@kind!='well']/mprml:flow[mprml:kind='gas lift']">
				     <xsl:sort select="mprml:qualifier"/>
				     <xsl:sort select="mprml:name"/>
					<tr>
						
						<td class="ColValueTxt"><xsl:value-of select="mprml:name"/></td>
						<td class="ColValueTxt"><xsl:value-of select="../mprml:name"/></td>
						<td class="ColValueTxt"><xsl:value-of select="mprml:qualifier"/></td>
						<td class="ColValueTxt"><xsl:value-of select="mprml:product/mprml:kind"/></td>
						<td class="ColValueTxt"><xsl:call-template name="BUILD_UOM_FOR_VOLUME">
							<xsl:with-param name="PRES" select="mprml:product/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
							<xsl:with-param name="TEMP" select="mprml:product/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
							<xsl:with-param name="UNIT" select="mprml:product/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
						</xsl:call-template></td>
						<td class="ColValue"><xsl:value-of select="mprml:product/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td>
						<td class="ColValue"><xsl:value-of select="mprml:product/mprml:period[mprml:kind='month to date']/mprml:volumeValue/mprml:volume"/></td>
						<td class="ColValue"><xsl:value-of select="mprml:product/mprml:period[mprml:kind='year to date']/mprml:volumeValue/mprml:volume"/></td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	
	<xsl:template name="BUILD_INJECTION_INFORMATION">
		<xsl:call-template name="OUTPUT_SECTION"><xsl:with-param name="SECTION_TXT">Injection Information</xsl:with-param></xsl:call-template>
		
		<div class="columns dpr20-report-table">
			<div class="column">
				<xsl:call-template name="OUTPUT_INJECTION_INFORMATION_TABLE"/>
			</div>
		</div>
	</xsl:template>
	<xsl:template name="OUTPUT_INJECTION_INFORMATION_TABLE">
		 <xsl:variable name="HAS_PRODUCT_NAME"><xsl:if test="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='injection']/mprml:product/mprml:name or $SHOW_ALL_COLUMNS=1">true</xsl:if></xsl:variable>
		<table id="injectionInformationTable">
			<xsl:attribute name="class"><xsl:value-of select="$INJECTION_INFORMATION_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead"><xsl:value-of select="$NAME_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$ASSET_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$QUALIFIER_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$PRODUCT_HEADER"/></th>
					<xsl:if test="$HAS_PRODUCT_NAME"><th class="ColHead"><xsl:value-of select="$PRODUCT_NAME"/></th></xsl:if>
					<th class="ColHead"><xsl:value-of select="$UOM_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$DAY_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$MONTH_TO_DATE_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$YEAR_TO_DATE_HEADER"/></th>
					
				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='injection']">
				    <xsl:sort select="mprml:qualifier"/>
				    <xsl:sort select="mprml:name"/>
				    <xsl:for-each select="mprml:product">
				    <xsl:sort select="mprml:kind"/>
						<tr>
							
							<td class="ColValueTxt"><xsl:value-of select="../mprml:name"/></td>
							<td class="ColValueTxt"><xsl:value-of select="../../mprml:name"/></td>
							<td class="ColValueTxt"><xsl:value-of select="../mprml:qualifier"/></td>
							<td class="ColValueTxt"><xsl:value-of select="mprml:kind"/></td>
							<xsl:if test="$HAS_PRODUCT_NAME"><td class="ColValueTxt"><xsl:value-of select="mprml:name"/></td></xsl:if>
							<td class="ColValueTxt"><xsl:call-template name="BUILD_UOM_FOR_VOLUME">
								<xsl:with-param name="PRES" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
								<xsl:with-param name="TEMP" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
								<xsl:with-param name="UNIT" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
							</xsl:call-template></td>
							<td class="ColValue"><xsl:value-of select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td>
							<td class="ColValue"><xsl:value-of select="mprml:period[mprml:kind='month to date']/mprml:volumeValue/mprml:volume"/></td>
							<td class="ColValue"><xsl:value-of select="mprml:period[mprml:kind='year to date']/mprml:volumeValue/mprml:volume"/></td>
						</tr>
					</xsl:for-each>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	
	
	
	
	<xsl:template name="BUILD_PRODUCTION_INFORMATION">
		<xsl:call-template name="OUTPUT_SECTION"><xsl:with-param name="SECTION_TXT">Production Information</xsl:with-param></xsl:call-template>
			 <xsl:variable name="HAS_PRODUCT_NAME"><xsl:if test="count(//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='production']/mprml:product/mprml:name)>0 or $SHOW_ALL_COLUMNS=1">true</xsl:if></xsl:variable>
		<div class="columns dpr20-report-table">
			<div class="column">
				<xsl:call-template name="OUTPUT_PRODUCTION_INFORMATION_TABLE"/>
			</div>
		</div>
	</xsl:template>
	<xsl:template name="OUTPUT_PRODUCTION_INFORMATION_TABLE">
		 <xsl:variable name="HAS_PRODUCT_NAME"><xsl:if test="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='production'][mprml:product/mprml:kind!='water']/mprml:product/mprml:name or $SHOW_ALL_COLUMNS=1">true</xsl:if></xsl:variable>
		<table id="exportInformationTable">
			<xsl:attribute name="class"><xsl:value-of select="$PRODUCTION_INFORMATION_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead"><xsl:value-of select="$NAME_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$ASSET_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$QUALIFIER_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$PRODUCT_HEADER"/></th>
					<xsl:if test="$HAS_PRODUCT_NAME='true' or $SHOW_ALL_COLUMNS=1"><th class="ColHead"><xsl:value-of select="$PRODUCT_NAME"/></th></xsl:if>
					<th class="ColHead"><xsl:value-of select="$UOM_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$DAY_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$MONTH_TO_DATE_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$YEAR_TO_DATE_HEADER"/></th>
					
				</tr>
			
			</thead>
			<tbody>
				<xsl:for-each select="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='production' or mprml:kind='sale'][mprml:product/mprml:kind!='water']">
					<xsl:sort select="mprml:name"/>
					<xsl:for-each select="mprml:product[mprml:kind!='water']">
						<tr>
							
							<td class="ColValueTxt"><xsl:value-of select="../mprml:name"/></td>
							<td class="ColValueTxt"><xsl:value-of select="../../mprml:name"/></td>
							<td class="ColValueTxt"><xsl:value-of select="../mprml:qualifier"/></td>
							<td class="ColValueTxt"><xsl:value-of select="mprml:kind"/></td>
							<xsl:if test="$HAS_PRODUCT_NAME='true' or $SHOW_ALL_COLUMNS=1"><td class="ColValueTxt"><xsl:value-of select="mprml:name"/></td></xsl:if>
							<td class="ColValueTxt"><xsl:call-template name="BUILD_UOM_FOR_VOLUME">
									<xsl:with-param name="PRES" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
									<xsl:with-param name="TEMP" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
									<xsl:with-param name="UNIT" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
							</xsl:call-template></td>
							<td class="ColValue"><xsl:value-of select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td>
							<td class="ColValue"><xsl:value-of select="mprml:period[mprml:kind='month to date']/mprml:volumeValue/mprml:volume"/></td>
							<td class="ColValue"><xsl:value-of select="mprml:period[mprml:kind='year to date']/mprml:volumeValue/mprml:volume"/></td>
						</tr>
					</xsl:for-each>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	
	
	<xsl:template name="BUILD_IMPORT_INFORMATION">
		<xsl:call-template name="OUTPUT_SECTION"><xsl:with-param name="SECTION_TXT">Import Information</xsl:with-param></xsl:call-template>
		
		<div class="columns dpr20-report-table">
			<div class="column">
				<xsl:call-template name="OUTPUT_IMPORT_INFORMATION_TABLE"/>
			</div>
		</div>
	</xsl:template>
	<xsl:template name="OUTPUT_IMPORT_INFORMATION_TABLE">
	    <!--defined variables that can be used to check if we have quality information related to gas handling-->
	   <xsl:variable name="HAS_DENSITY"><xsl:if test="//mprml:flow[mprml:kind='import']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:densityValue or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
	   <xsl:variable name="HAS_WOBBE"><xsl:if test="//mprml:flow[mprml:kind='import']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:wobbeIndex or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
	   <xsl:variable name="HAS_GCV"><xsl:if test="//mprml:flow[mprml:kind='import']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:grossCalorificValueStd or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
	   <xsl:variable name="HAS_CO2"><xsl:if test="//mprml:flow[mprml:kind='import']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:componentContent[mprml:kind='carbon dioxide gas'] or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
	   <xsl:variable name="HAS_H2S">	<xsl:if test="//mprml:flow[mprml:kind='import']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:componentContent[mprml:kind='hydrogen sulfide'] or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
		<table id="importInformationTable">
			<xsl:attribute name="class"><xsl:value-of select="$IMPORT_INFORMATION_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHeadRec"><xsl:value-of select="$NAME_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$ASSET_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$QUALIFIER_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$PRODUCT_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$UOM_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$DAY_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$MONTH_TO_DATE_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$YEAR_TO_DATE_HEADER"/></th>
					<xsl:if test="$HAS_DENSITY='true'">
						<th class="ColHeadOpt">Density</th>
				    </xsl:if>
				    <xsl:if test="$HAS_WOBBE='true'">
						<th class="ColHeadOpt">Wobbe Index</th>
					</xsl:if>
					<xsl:if test="$HAS_GCV='true'">
						<th class="ColHeadOpt">GCV</th>
					</xsl:if>
					<xsl:if test="$HAS_CO2='true'">
						<th class="ColHeadOpt">CO<sub>2</sub></th>
					</xsl:if>
					<xsl:if test="$HAS_H2S='true'">
						<th class="ColHeadOpt">H<sub>2</sub>S</th>		
					</xsl:if>
					
					
				</tr>
					<!--just check if we have any of the columns that carry uoms-->
				<xsl:if test="$HAS_CO2='true' or $HAS_DENSITY='true' or $HAS_GCV='true' or $HAS_H2S='true' or $HAS_WOBBE='true'">
				<tr>
					<th class="ColHeadUomRec"> </th>
					<th class="ColHeadUomRec"></th> 
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<xsl:if test="$HAS_DENSITY='true'">
					<th class="ColHeadUomOpt"><xsl:call-template name="BUILD_UOM_FOR_DENSITY">
								<xsl:with-param name="PRES" select="//mprml:flow[mprml:kind='import']/mprml:product/mprml:period[mprml:kind='day']/mprml:densityValue/mprml:pres[1]"/>
								<xsl:with-param name="TEMP" select="//mprml:flow[mprml:kind='import']/mprml:product/mprml:period[mprml:kind='day']/mprml:densityValue/mprml:temp[1]"/>
								<xsl:with-param name="UNIT" select="//mprml:flow[mprml:kind='import']/mprml:product/mprml:period[mprml:kind='day']/mprml:densityValue/mprml:density/@uom[1]"/>
				   </xsl:call-template></th>
				   </xsl:if>
				   <xsl:if test="$HAS_WOBBE='true'">
						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:flow[mprml:kind='import']/mprml:product/mprml:period[mprml:kind='day']/mprml:wobbeIndex/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_GCV='true'">
						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:flow[mprml:kind='import']/mprml:product/mprml:period[mprml:kind='day']/mprml:grossCalorificValueStd/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_CO2='true'">
						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:flow[mprml:kind='import']/mprml:product/mprml:period[mprml:kind='day']/mprml:componentContent[mprml:kind='carbon dioxide gas']/mprml:concentration/@uom"/></th>
					</xsl:if>
					<xsl:if test="$HAS_H2S='true'">
					<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:flow[mprml:kind='import']/mprml:product/mprml:period[mprml:kind='day']/mprml:componentContent[mprml:kind='hydrogen sulfide']/mprml:concentration/@uom"/></th>
	                </xsl:if>

				</tr>
			   </xsl:if>
			</thead>
			<tbody>
				<xsl:for-each select="//mprml:flow[mprml:kind='import']">
					<xsl:sort select="mprml:qualifier"/>
					<xsl:sort select="mprml:name"/>
					<xsl:for-each select="mprml:product">
					<xsl:sort select="mprml:kind"/>
					<tr>
						
						<td class="ColValueTxtRec"><xsl:value-of select="../mprml:name"/></td>
						<td class="ColValueTxtRec"><xsl:value-of select="../../mprml:name"/></td>
						<td class="ColValueTxtRec"><xsl:value-of select="../mprml:qualifier"/></td>
						<td class="ColValueTxtRec"><xsl:value-of select="mprml:kind"/></td>
						<td class="ColValueTxtRec"><xsl:call-template name="BUILD_UOM_FOR_VOLUME">
							<xsl:with-param name="PRES" select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:volumeValue/mprml:pres"/>
							<xsl:with-param name="TEMP" select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:volumeValue/mprml:temp"/>
							<xsl:with-param name="UNIT" select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:volumeValue/mprml:volume/@uom"/>
						</xsl:call-template></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:volumeValue/mprml:volume"/></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:period[mprml:kind='month to date']/mprml:volumeValue/mprml:volume"/></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:period[mprml:kind='year to date']/mprml:volumeValue/mprml:volume"/></td>
						<xsl:if test="$HAS_DENSITY='true'">
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:densityValue/mprml:density"/></td>
						</xsl:if>
						<xsl:if test="$HAS_WOBBE='true'">
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:wobbeIndex"/></td>
						</xsl:if>
						<xsl:if test="$HAS_GCV='true'">
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:grossCalorificValueStd"/></td>
						</xsl:if>
						<xsl:if test="$HAS_CO2='true'">
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:componentContent[mprml:kind='carbon dioxide gas']/mprml:concentration"/></td>
						</xsl:if>
						<xsl:if test="$HAS_H2S='true'">
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:componentContent[mprml:kind='hydrogen sulfide']/mprml:concentration"/></td>
						</xsl:if>
					</tr>
					</xsl:for-each>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	
	
	<xsl:template name="BUILD_INVENTORY_INFORMATION">
		<xsl:call-template name="OUTPUT_SECTION"><xsl:with-param name="SECTION_TXT">Inventory Information</xsl:with-param></xsl:call-template>
		
		<div class="columns dpr20-report-table">
			<div class="column">
				<xsl:call-template name="OUTPUT_INVENTORY_INFORMATION_TABLE"/>
			</div>
		</div>
	</xsl:template>
	<xsl:template name="OUTPUT_INVENTORY_INFORMATION_TABLE">
		
		<table id="inventoryInformationTable">
			<xsl:attribute name="class"><xsl:value-of select="$INVENTORY_INFORMATION_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHeadOpt"><xsl:value-of select="$NAME_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$ASSET_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$QUALIFIER_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$PRODUCT_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$UOM_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$DAY_HEADER"/></th>
								
					
					
					
					
				</tr>
				
				
			</thead>
			<tbody>
				<xsl:for-each select="//mprml:flow[mprml:kind='inventory']">
					<xsl:sort select="mprml:qualifier"/>
					<xsl:sort select="mprml:name"/>
					<xsl:for-each select="mprml:product">
						<xsl:sort select="mprml:kind"/>
						<tr>
							
							<td class="ColValueTxtOpt"><xsl:value-of select="../mprml:name"/></td>
							<td class="ColValueTxtOpt"><xsl:value-of select="../../mprml:name"/></td>
							<td class="ColValueTxtOpt"><xsl:value-of select="../mprml:qualifier"/></td>
							<td class="ColValueTxtOpt"><xsl:value-of select="mprml:kind"/></td>
							<td class="ColValueTxtOpt"><xsl:call-template name="BUILD_UOM_FOR_VOLUME">
								<xsl:with-param name="PRES" select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:volumeValue/mprml:pres"/>
								<xsl:with-param name="TEMP" select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:volumeValue/mprml:temp"/>
								<xsl:with-param name="UNIT" select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:volumeValue/mprml:volume/@uom"/>
							</xsl:call-template></td>
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:volumeValue/mprml:volume"/></td>
							
						</tr>
					</xsl:for-each>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	
	
	
	
	
	<xsl:template name="BUILD_EXPORT_INFORMATION">
		<xsl:call-template name="OUTPUT_SECTION"><xsl:with-param name="SECTION_TXT">Export Information</xsl:with-param></xsl:call-template>
		
		<div class="columns dpr20-report-table">
			<div class="column">
				<xsl:call-template name="OUTPUT_EXPORT_INFORMATION_TABLE"/>
			</div>
		</div>
	</xsl:template>
	<xsl:template name="OUTPUT_EXPORT_INFORMATION_TABLE">
	   <!--defined variables that can be used to check if we have quality information related to gas handling-->
	   <xsl:variable name="HAS_DENSITY"><xsl:if test="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:densityValue or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
	     <xsl:variable name="HAS_MASS"><xsl:if test="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:mass or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
	   <xsl:variable name="HAS_WOBBE"><xsl:if test="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:wobbeIndex or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
	   <xsl:variable name="HAS_GCV"><xsl:if test="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:grossCalorificValueStd or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
	   <xsl:variable name="HAS_CO2"><xsl:if test="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:componentContent[mprml:kind='carbon dioxide gas'] or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
	   <xsl:variable name="HAS_H2S">	<xsl:if test="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:componentContent[mprml:kind='hydrogen sulfide'] or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
	    <xsl:variable name="HAS_PRODUCT_NAME"><xsl:if test="//mprml:facility[mprml:name/@kind!='wellbore' and mprml:name/@kind!='well']/mprml:flow[mprml:kind='export']/mprml:product/mprml:name or $SHOW_ALL_COLUMNS=1">true</xsl:if></xsl:variable>
		<table id="exportInformationTable">
			<xsl:attribute name="class"><xsl:value-of select="$EXPORT_INFORMATION_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHeadRec"><xsl:value-of select="$NAME_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$ASSET_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$QUALIFIER_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$PRODUCT_HEADER"/></th>
					<xsl:if test="$HAS_PRODUCT_NAME='true'"><th class="ColHeadRec"><xsl:value-of select="$PRODUCT_NAME"/></th></xsl:if>
					<th class="ColHeadRec"><xsl:value-of select="$UOM_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$DAY_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$MONTH_TO_DATE_HEADER"/></th>
					<th class="ColHeadRec"><xsl:value-of select="$YEAR_TO_DATE_HEADER"/></th>
					<!--check if we have density-->
					<xsl:if test="$HAS_MASS='true'">
						<th class="ColHeadOpt">Mass</th>
                    </xsl:if>
					<!--check if we have density-->
					<xsl:if test="$HAS_DENSITY='true'">
						<th class="ColHeadOpt">Density</th>
                    </xsl:if>
                    <!--check if we have wobbe index-->
                    <xsl:if test="$HAS_WOBBE='true'">
						<th class="ColHeadOpt">Wobbe Index</th>
					</xsl:if>
					 <!--check if we have gcv-->
                    <xsl:if test="$HAS_GCV='true'">
						<th class="ColHeadOpt">GCV</th>
					</xsl:if>
					<xsl:if test="$HAS_CO2='true'">
						<th class="ColHeadOpt">CO<sub>2</sub></th>
					</xsl:if>
					<xsl:if test="$HAS_H2S='true'">
						<th class="ColHeadOpt">H<sub>2</sub>S</th>					
					</xsl:if>
					
	

				</tr>
				<!--just check if we have any of the columns that carry uoms-->
				<xsl:if test="$HAS_CO2='true' or $HAS_DENSITY='true' or $HAS_GCV='true' or $HAS_H2S='true' or $HAS_WOBBE='true' or $HAS_MASS='true'">
				<tr>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<xsl:if test="$HAS_PRODUCT_NAME='true'"><th class="ColHeadUomRec"></th></xsl:if>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<th class="ColHeadUomRec"></th>
					<xsl:if test="$HAS_MASS='true'">
						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:mass/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_DENSITY='true'">
					<th class="ColHeadUomOpt"><xsl:call-template name="BUILD_UOM_FOR_DENSITY">
								<xsl:with-param name="PRES" select="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:densityValue/mprml:pres[1]"/>
								<xsl:with-param name="TEMP" select="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:densityValue/mprml:temp[1]"/>
								<xsl:with-param name="UNIT" select="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:densityValue/mprml:density/@uom[1]"/>
				   </xsl:call-template></th>
				   </xsl:if>
					<xsl:if test="$HAS_WOBBE='true'">
						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:wobbeIndex/@uom[1]"/></th>
					</xsl:if>
                    <xsl:if test="$HAS_GCV='true'">

						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:grossCalorificValueStd/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_CO2='true'">

						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:componentContent[mprml:kind='carbon dioxide gas']/mprml:concentration/@uom"/></th>
					</xsl:if>
					<xsl:if test="$HAS_H2S='true'">
						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:flow[mprml:kind='export']/mprml:product/mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:componentContent[mprml:kind='hydrogen sulfide']/mprml:concentration/@uom"/></th>
		             </xsl:if>

				</tr>
			   </xsl:if>
			</thead>
			<tbody>
				<xsl:for-each select="//mprml:flow[mprml:kind='export']">
				<xsl:sort select="mprml:qualifier"/>
				<xsl:sort select="mprml:name"/>
				<xsl:for-each select="mprml:product">
					<tr>
						
						<td class="ColValueTxtRec"><xsl:value-of select="../mprml:name"/></td>
						<td class="ColValueTxtRec"><xsl:value-of select="../../mprml:name"/></td>
						<td class="ColValueTxtRec"><xsl:value-of select="../mprml:qualifier"/></td>
						<td class="ColValueTxtRec"><xsl:value-of select="mprml:kind"/></td>
						<xsl:if test="$HAS_PRODUCT_NAME='true'"><td class="ColValueTxtRec"><xsl:value-of select="mprml:name"/></td></xsl:if>
						<td class="ColValueTxtRec"><xsl:call-template name="BUILD_UOM_FOR_VOLUME">
							<xsl:with-param name="PRES" select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:volumeValue/mprml:pres"/>
							<xsl:with-param name="TEMP" select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:volumeValue/mprml:temp"/>
							<xsl:with-param name="UNIT" select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:volumeValue/mprml:volume/@uom"/>
						</xsl:call-template></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:volumeValue/mprml:volume"/></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:period[mprml:kind='month to date']/mprml:volumeValue/mprml:volume"/></td>
						<td class="ColValueRec"><xsl:value-of select="mprml:period[mprml:kind='year to date']/mprml:volumeValue/mprml:volume"/></td>
						<xsl:if test="$HAS_MASS='true'">							
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:mass"/></td>
						</xsl:if>
						<xsl:if test="$HAS_DENSITY='true'">							
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:densityValue/mprml:density"/></td>
						</xsl:if>
						<xsl:if test="$HAS_WOBBE='true'">
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:wobbeIndex"/></td>
						</xsl:if>
						<xsl:if test="$HAS_GCV='true'">
							<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:grossCalorificValueStd"/></td>
						</xsl:if>
						<xsl:if test="$HAS_CO2='true'">

						<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:componentContent[mprml:kind='carbon dioxide gas']/mprml:concentration"/></td>
						</xsl:if>
						<xsl:if test="$HAS_H2S='true'">
						
						<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day' or mprml:kind='gas day']/mprml:componentContent[mprml:kind='hydrogen sulfide']/mprml:concentration"/></td>
						</xsl:if>
					</tr>
				</xsl:for-each>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	
	
	
		
	
	
	
	<xsl:template name="BUILD_ACTIVITY_INFORMATION">
		<xsl:call-template name="OUTPUT_SECTION"><xsl:with-param name="SECTION_TXT">Activity Information</xsl:with-param></xsl:call-template>
		<xsl:call-template name="OUTPUT_SUB_SECTION"><xsl:with-param name="SECTION_SUB_TXT">Production and operation</xsl:with-param></xsl:call-template>
		<div class="columns dpr20-report-table">
			<div class="column is-three-quarters">
				<xsl:call-template name="OUTPUT_ACTIVITY_COMMENTS_PRODUCTION_TABLE"/>
			</div>
		</div>
		<xsl:if test="//mprml:productionActivity/mprml:operationalComment[mprml:type='other']">
		<xsl:call-template name="OUTPUT_SUB_SECTION"><xsl:with-param name="SECTION_SUB_TXT">Other</xsl:with-param></xsl:call-template>
		<div class="columns dpr20-report-table">
			<div class="column">
				<xsl:call-template name="OUTPUT_OTHER_COMMENTS_PRODUCTION_TABLE"/>
			</div>
		</div>
		</xsl:if>
		<xsl:if test="//mprml:productionActivity/mprml:operationalComment[mprml:type='maintenance']">
		<xsl:call-template name="OUTPUT_SUB_SECTION"><xsl:with-param name="SECTION_SUB_TXT">Maintenance</xsl:with-param></xsl:call-template>
		<div class="columns dpr20-report-table">
			<div class="column">
				<xsl:call-template name="OUTPUT_MAINTENANCE_COMMENTS_PRODUCTION_TABLE"/>
			</div>
		</div>
		</xsl:if>
	</xsl:template>
	
	
	<xsl:template name="OUTPUT_ACTIVITY_COMMENTS_PRODUCTION_TABLE">
		
			<table id="prodCommentsTable">
				<xsl:attribute name="class"><xsl:value-of select="$ACTIVITY_COMMENTS_PRODUCTION_TABLE_CLASS"/></xsl:attribute>
				<thead>
					<tr>
						<th class="ColHeadCommentTime">Time</th>
						<th class="ColHeadCommentAsset">Asset</th>
						<th class="ColHead">Comment</th>
					</tr>
				</thead>
					<xsl:for-each select="//mprml:productionActivity/mprml:operationalComment[mprml:type='production']">
						<xsl:sort select="../../mprml:installation"/>
						<xsl:sort select="mprml:dTimStart"/>
						<tr>
							<td class="ColValueTxt"><xsl:call-template name="OUTPUT_DTIM"><xsl:with-param name="DTIM" select="mprml:dTimStart"/></xsl:call-template></td>
						    <td class="ColValueTxt"><xsl:value-of select="../../mprml:installation"/></td>
							<td class="ColValueWrapped"><xsl:value-of select="mprml:comment"/></td>
						</tr>
					</xsl:for-each>
			    <tbody>

			    </tbody>
			</table>
		
			    
		
	</xsl:template>
	
	<xsl:template name="OUTPUT_OTHER_COMMENTS_PRODUCTION_TABLE">
		
		<table id="otherCommentsTable">
			<xsl:attribute name="class"><xsl:value-of select="$ACTIVITY_COMMENTS_PRODUCTION_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHeadCommentTime">Time</th>
					<th class="ColHeadOpt">Asset</th>
					<th class="ColHeadOpt">Comment</th>
				</tr>
			</thead>
			<xsl:for-each select="//mprml:productionActivity/mprml:operationalComment[mprml:type='other']">
				<xsl:sort select="../../mprml:installation"/>
				<xsl:sort select="mprml:dTimeStart"/>
				<tr>
					<td class="ColValueTxtOpt"><xsl:call-template name="OUTPUT_DTIM"><xsl:with-param name="DTIM" select="mprml:dTimStart"/></xsl:call-template></td>
					<td class="ColValueOpt"><xsl:value-of select="../../mprml:installation"/></td>
					<td class="ColValueWrappedOpt"><xsl:value-of select="mprml:comment"/></td>
				</tr>
				
			</xsl:for-each>
			<tbody>
				
			</tbody>
		</table>
		
		
		
	</xsl:template>
	
	<xsl:template name="OUTPUT_MAINTENANCE_COMMENTS_PRODUCTION_TABLE">
		
		<table id="prodWellsTable">
			<xsl:attribute name="class"><xsl:value-of select="$ACTIVITY_COMMENTS_PRODUCTION_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHeadCommentTime">Start</th>
					<th class="ColHeadOpt">Asset</th>
					<th class="ColHeadOpt">Comment</th>
				</tr>
			</thead>
			<xsl:for-each select="//mprml:productionActivity/mprml:operationalComment[mprml:type='maintenance']">
				<xsl:sort select="../../mprml:installation"/>
				<xsl:sort select="mprml:dTimStart"/>
				<tr>
					<td class="ColValueTxtOpt"><xsl:call-template name="OUTPUT_DTIM"><xsl:with-param name="DTIM" select="mprml:dTimStart"/></xsl:call-template></td>
					
					<td class="ColValueOpt"><xsl:value-of select="../../mprml:installation"/></td>
					<td class="ColValueWrappedOpt"><xsl:value-of select="mprml:comment"/></td>
				</tr>
			</xsl:for-each>
			<tbody>
				
			</tbody>
		</table>
		
		
		
	</xsl:template>
	
    
    <xsl:template name="BUILD_CONSUME_INFORMATION">
			<xsl:call-template name="OUTPUT_SECTION"><xsl:with-param name="SECTION_TXT">Consume Information</xsl:with-param></xsl:call-template>
			<xsl:call-template name="OUTPUT_SUB_SECTION"><xsl:with-param name="SECTION_SUB_TXT">Consume fuel and flare</xsl:with-param></xsl:call-template>
			<div class="columns dpr20-report-table">
				<div class="column">
					<xsl:call-template name="OUTPUT_CONSUME_FUEL_FLARE_INFORMATION_TABLE"/>
				</div>
			</div>
			<xsl:if test="//mprml:flow[(mprml:kind!='consume - fuel' and mprml:kind!='consume - flare' and starts-with(mprml:kind,'consume')) or (mprml:kind='consume - fuel' and mprml:product/mprml:kind='diesel')] and $INCLUDE_ALL_SECTIONS!=1">
			<xsl:call-template name="OUTPUT_SUB_SECTION"><xsl:with-param name="SECTION_SUB_TXT">Consume other</xsl:with-param></xsl:call-template>
			<div class="columns dpr20-report-table">
				<div class="column">
					<xsl:call-template name="OUTPUT_CONSUME_OTHER"/>
				</div>
			</div>
			</xsl:if>
    </xsl:template>
    
    
    <xsl:template name="OUTPUT_CONSUME_OTHER">
            <xsl:variable name="HAS_PRODUCT_NAME"><xsl:if test="//mprml:flow[(mprml:kind!='consume - fuel' and mprml:kind!='consume - flare' and starts-with(mprml:kind,'consume')) or (mprml:kind='consume - fuel' and mprml:product/mprml:kind='diesel')]/mprml:product/mprml:name or $SHOW_ALL_COLUMNS=1">true</xsl:if></xsl:variable>
    	<table id="consumeOtherTable">
    		<xsl:attribute name="class"><xsl:value-of select="$CONSUME_OTHER_TABLE_CLASS"/></xsl:attribute>
    		<thead>
				<tr>
					<th class="ColHeadOpt"><xsl:value-of select="$NAME_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$ASSET_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$FLOW_KIND_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$QUALIFIER_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$PRODUCT_HEADER"/></th>
					<xsl:if test="$HAS_PRODUCT_NAME='true'"><th class="ColHeadOpt"><xsl:value-of select="$PRODUCT_NAME"/></th></xsl:if>
					<th class="ColHeadOpt"><xsl:value-of select="$UOM_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$DAY_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$MONTH_TO_DATE_HEADER"/></th>
					<th class="ColHeadOpt"><xsl:value-of select="$YEAR_TO_DATE_HEADER"/></th>
                   </tr>
			</thead>
    		
    		<xsl:for-each select="//mprml:flow[(mprml:kind!='consume - fuel' and mprml:kind!='consume - flare' and starts-with(mprml:kind,'consume')) or (mprml:kind='consume - fuel' and mprml:product/mprml:kind='diesel')]">
    			
    			<xsl:sort select="mprml:kind"/>
			   <xsl:sort select="mprml:qualifier"/>
				<xsl:sort select="mprml:name"/>
				<xsl:for-each select="mprml:product">
					<tr>
						<td class="ColValueTxtOpt"><xsl:value-of select="../mprml:name"/></td>
						<td class="ColValueTxtOpt"><xsl:value-of select="../../mprml:name"/></td>
						<td class="ColValueTxtOpt"><xsl:value-of select="../mprml:kind"/></td>
						<td class="ColValueTxtOpt"><xsl:value-of select="../mprml:qualifier"/></td>
						<td class="ColValueTxtOpt"><xsl:value-of select="mprml:kind"/></td>
						<xsl:if test="$HAS_PRODUCT_NAME='true'"><td class="ColValueTxtOpt"><xsl:value-of select="mprml:name"/></td></xsl:if>
						<td class="ColValueTxtOpt"><xsl:call-template name="BUILD_UOM_FOR_VOLUME">
							<xsl:with-param name="PRES" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
							<xsl:with-param name="TEMP" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
							<xsl:with-param name="UNIT" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
						</xsl:call-template>
						</td>
						<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td>
						<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='month to date']/mprml:volumeValue/mprml:volume"/></td>
						<td class="ColValueOpt"><xsl:value-of select="mprml:period[mprml:kind='year to date']/mprml:volumeValue/mprml:volume"/></td>
						
					</tr>
				</xsl:for-each>
    		</xsl:for-each>
    		<tbody>
    			
    		</tbody>
    	</table>
    </xsl:template>
    
    <xsl:template name="OUTPUT_CONSUME_FUEL_FLARE_INFORMATION_TABLE">
     <xsl:variable name="HAS_PRODUCT_NAME"><xsl:if test="//mprml:facility/mprml:flow[mprml:kind='consume - fuel' or mprml:kind='consume - flare'][mprml:product/mprml:kind!='diesel']/mprml:product/mprml:name or $SHOW_ALL_COLUMNS=1">true</xsl:if></xsl:variable>
		<table id="consumeFuelFlareInformationTable">
			<xsl:attribute name="class"><xsl:value-of select="$CONSUME_FUEL_FLARE_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead"><xsl:value-of select="$NAME_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$ASSET_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$FLOW_KIND_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$QUALIFIER_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$PRODUCT_HEADER"/></th>
					<xsl:if test="$HAS_PRODUCT_NAME"><th class="ColHead"><xsl:value-of select="$PRODUCT_NAME"/></th></xsl:if>
					<th class="ColHead"><xsl:value-of select="$UOM_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$DAY_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$MONTH_TO_DATE_HEADER"/></th>
					<th class="ColHead"><xsl:value-of select="$YEAR_TO_DATE_HEADER"/></th>
                   </tr>
			</thead>
			<tbody>
			   <xsl:for-each select="//mprml:facility/mprml:flow[mprml:kind='consume - fuel' or mprml:kind='consume - flare'][mprml:product/mprml:kind!='diesel']">
			   <xsl:sort select="mprml:kind"/>
			   <xsl:sort select="mprml:qualifier"/>
				<xsl:sort select="mprml:name"/>
				<xsl:for-each select="mprml:product">
					<tr>
						<td class="ColValueTxt"><xsl:value-of select="../mprml:name"/></td>
						<td class="ColValueTxt"><xsl:value-of select="../../mprml:name"/></td>
						<td class="ColValueTxt"><xsl:value-of select="../mprml:kind"/></td>
						<td class="ColValueTxt"><xsl:value-of select="../mprml:qualifier"/></td>
						<td class="ColValueTxt"><xsl:value-of select="mprml:kind"/></td>
						<xsl:if test="$HAS_PRODUCT_NAME"><td class="ColValueTxt"><xsl:value-of select="mprml:name"/></td></xsl:if>
						<td class="ColValueTxt"><xsl:call-template name="BUILD_UOM_FOR_VOLUME">
							<xsl:with-param name="PRES" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
							<xsl:with-param name="TEMP" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
							<xsl:with-param name="UNIT" select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
						</xsl:call-template>
						</td>
						<td class="ColValue"><xsl:value-of select="mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td>
						<td class="ColValue"><xsl:value-of select="mprml:period[mprml:kind='month to date']/mprml:volumeValue/mprml:volume"/></td>
						<td class="ColValue"><xsl:value-of select="mprml:period[mprml:kind='year to date']/mprml:volumeValue/mprml:volume"/></td>
						
					</tr>
				</xsl:for-each>
				</xsl:for-each>
			</tbody>
	</table>
    </xsl:template>    
    
    
  
	
	<xsl:template name="BUILD_WELL_INFORMATION">
		<xsl:call-template name="OUTPUT_SECTION"><xsl:with-param name="SECTION_TXT">Well Information</xsl:with-param></xsl:call-template>
		<!--first add the production well information-->
		<xsl:call-template name="OUTPUT_PROD_WELLS"/>
		<!--add inj well information-->
		<xsl:call-template name="OUTPUT_INJ_WELLS"/>
	</xsl:template>
	
	<xsl:template name="OUTPUT_PROD_WELLS">
	   <xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']">
			<xsl:call-template name="OUTPUT_SUB_SECTION"><xsl:with-param name="SECTION_SUB_TXT">Production wells</xsl:with-param></xsl:call-template>
			<div class="columns dpr20-report-table">
				<div class="column">
					<xsl:call-template name="BUILD_PROD_WELLS_TABLE"/>
				</div>
			</div>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="OUTPUT_INJ_WELLS">
	   <xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='injection']">
			<xsl:call-template name="OUTPUT_SUB_SECTION"><xsl:with-param name="SECTION_SUB_TXT">Injection wells</xsl:with-param></xsl:call-template>
			<div class="columns dpr20-report-table">
				<div class="column">
					<xsl:call-template name="BUILD_INJ_WELLS_TABLE"/>
				</div>
			</div>
		</xsl:if>
	</xsl:template>
	
  
	
	<xsl:template name="BUILD_PROD_WELLS_TABLE">
		<table id="prodWellsTable">
			<xsl:attribute name="class"><xsl:value-of select="$PROD_WELLS_TABLE_CLASS"/></xsl:attribute>
			<xsl:variable name="HAS_BHP"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='bottomhole pressure'] or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_BHT"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='bottomhole temperature'] or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_WHP"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='wellhead pressure']or $SHOW_ALL_COLUMNS=1 "><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_WHT"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='wellhead temperature'] or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_DSCP"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='wellhead pressure DSCP'] or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_CHOKE"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='choke size']"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			
			<xsl:variable name="HAS_DSCT"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='wellhead temperature DSCT']or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_ANNULUS"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='annulus pressure'] or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_GL"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='gas lift'] or $SHOW_ALL_COLUMNS=1"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_OIL"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='oil - net']] or $SHOW_ALL_COLUMNS=1">true</xsl:if></xsl:variable>
			<xsl:variable name="HAS_CONDENSATE"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='condensate - net']] or $SHOW_ALL_COLUMNS=1">true</xsl:if></xsl:variable>
			<xsl:variable name="HAS_GAS"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='gas']] or $SHOW_ALL_COLUMNS=1">true</xsl:if></xsl:variable>
			<xsl:variable name="HAS_WATER"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='water']] or $SHOW_ALL_COLUMNS=1">true</xsl:if></xsl:variable>
			<thead>
				<tr>
					<th class="ColHead">Well / Wellbore</th>
					<th class="ColHead">Uptime</th>
					<xsl:if test="$HAS_CHOKE='true'">
						<th class="ColHeadRec">Choke</th>
					</xsl:if>
					<xsl:if test="$HAS_WHP='true'">
						<th class="ColHeadRec">WHP</th>
					</xsl:if>
					<xsl:if test="$HAS_WHT='true'">
						<th class="ColHeadRec">WHT</th>
					</xsl:if>
					<xsl:if test="$HAS_BHP='true'">
						<th class="ColHeadRec">BHP</th>
					</xsl:if>
					<xsl:if test="$HAS_BHT='true'">
						<th class="ColHeadRec">BHT</th>
					</xsl:if>
					<xsl:if test="$HAS_DSCP='true'">
						<th class="ColHeadOpt">DSCP</th>
					</xsl:if>
					<xsl:if test="$HAS_DSCT='true'">
						<th class="ColHeadOpt">DSCT</th>
					</xsl:if>
					<xsl:if test="$HAS_ANNULUS='true'">
						<th class="ColHeadOpt">Annulus Press</th>
					</xsl:if>
					<!--just output the oil column if we have any production wells with allocated oil-->
					<xsl:if test="$HAS_OIL='true'">
						<th class="ColHeadRec">Oil</th>
					</xsl:if>
					<!--just output the condensate column if we have any production wells with condensate-->
					<xsl:if test="$HAS_CONDENSATE='true'">
						<th class="ColHeadRec">Condensate</th>
					</xsl:if>
					<!--just output the gas column if we have any production wells with gas-->
					<xsl:if test="$HAS_GAS='true'">
						<th class="ColHeadRec">Gas</th>
					</xsl:if>
					<!--just output the water column if we have any production wells with water-->
					<xsl:if test="$HAS_WATER='true'">
						<th class="ColHeadRec">Water</th>
					</xsl:if>
					<xsl:if test="$HAS_GL='true'">
						<th class="ColHeadOpt">GL</th>
					</xsl:if>
				</tr>
				<tr>
				
					<th class="ColHeadUom"></th>
					<th class="ColHeadUom"><xsl:choose>
						<xsl:when test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='facility uptime']"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:parameterSet[mprml:name='facility uptime']/mprml:parameter/mprml:measureValue/@uom[1]"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:operationTime/@uom[1]"/></xsl:otherwise>
					</xsl:choose></th>
					<xsl:if test="$HAS_CHOKE='true'">
						<th class="ColHeadUomRec"></th>
					</xsl:if>
					<xsl:if test="$HAS_WHP='true'">
						<th class="ColHeadUomRec"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='wellhead pressure']/mprml:parameter/mprml:measureValue/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_WHT='true'">
						<th class="ColHeadUomRec"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='wellhead temperature']/mprml:parameter/mprml:measureValue/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_BHP='true'">
						<th class="ColHeadUomRec"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='bottomhole pressure']/mprml:parameter/mprml:measureValue/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_BHT='true'">
						<th class="ColHeadUomRec"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='bottomhole temperature']/mprml:parameter/mprml:measureValue/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_DSCP='true'">
						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='wellhead pressure DSCP']/mprml:parameter/mprml:measureValue/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_DSCT='true'">
						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='wellhead temperature DSCT']/mprml:parameter/mprml:measureValue/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_ANNULUS='true'">
						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='production']/mprml:parameterSet[mprml:name='annulus pressure']/mprml:parameter/mprml:measureValue/@uom[1]"/></th>
					</xsl:if>
					<!--just output the oil column if we have any production wells with allocated oil-->
					<xsl:if test="$HAS_OIL='true'">
						<th class="ColHeadUomRec">
							<xsl:call-template name="BUILD_UOM_FOR_VOLUME">
							<xsl:with-param name="UNIT" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='oil - net']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
							<xsl:with-param name="TEMP" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='oil - net']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
							<xsl:with-param name="PRES" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='oil - net']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
							</xsl:call-template>
					</th>
					</xsl:if>
					<!--just output the condensate column if we have any production wells with condensate-->
					<xsl:if test="$HAS_CONDENSATE='true'">
						<th class="ColHeadUomRec">
							<xsl:call-template name="BUILD_UOM_FOR_VOLUME">
							<xsl:with-param name="UNIT" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='condensate - net']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
							<xsl:with-param name="TEMP" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='condensate - net']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
							<xsl:with-param name="PRES" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='condensate - net']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
							</xsl:call-template>
				</th>
					</xsl:if>
					<!--just output the gas column if we have any production wells with gas-->
					<xsl:if test="$HAS_GAS='true'">
						<th class="ColHeadUomRec">
						   	<xsl:call-template name="BUILD_UOM_FOR_VOLUME">
							<xsl:with-param name="UNIT" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='gas']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
							<xsl:with-param name="TEMP" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='gas']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
							<xsl:with-param name="PRES" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='gas']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
							</xsl:call-template>
						
						
						</th>
					</xsl:if>
					<!--just output the water column if we have any production wells with water-->
					<xsl:if test="$HAS_WATER='true'">
						<th class="ColHeadUomRec">
							<xsl:call-template name="BUILD_UOM_FOR_VOLUME">
							<xsl:with-param name="UNIT" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='water']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
							<xsl:with-param name="TEMP" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='water']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
							<xsl:with-param name="PRES" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='water']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
							</xsl:call-template>
						</th>
					</xsl:if>
					<xsl:if test="$HAS_GL='true'">
					<th class="ColHeadUomOpt"><xsl:call-template name="BUILD_UOM_FOR_VOLUME">
							<xsl:with-param name="UNIT" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='gas lift']/mprml:product[mprml:kind='gas']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
							<xsl:with-param name="TEMP" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='gas lift']/mprml:product[mprml:kind='gas']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
							<xsl:with-param name="PRES" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='gas lift']/mprml:product[mprml:kind='gas']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
							</xsl:call-template>
						</th>
					</xsl:if>
				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow[mprml:kind='production' or mprml:kind='gas lift']]">
				    <xsl:sort select="mprml:name"/>
					<tr>
						<td class="ColValueTxt"><xsl:value-of select="mprml:name"/></td>
						<td class="ColValue"><xsl:choose>
							<xsl:when test="mprml:parameterSet[mprml:name='facility uptime']"><xsl:value-of select="mprml:parameterSet[mprml:name='facility uptime']/mprml:parameter/mprml:measureValue"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="mprml:operationTime"/></xsl:otherwise>
						</xsl:choose></td>
						<xsl:if test="$HAS_CHOKE='true'">
							<td class="ColValueRec"><xsl:value-of select="mprml:parameterSet[mprml:name='choke size']/mprml:parameter/mprml:measureValue"/>
							<xsl:text> </xsl:text><xsl:value-of select="mprml:parameterSet[mprml:name='choke size']/mprml:parameter/mprml:measureValue/@uom"/></td>
						</xsl:if>
						<xsl:if test="$HAS_WHP='true'">
							<td class="ColValueRec"><xsl:value-of select="mprml:parameterSet[mprml:name='wellhead pressure']/mprml:parameter/mprml:measureValue"/></td>
						</xsl:if>
						<xsl:if test="$HAS_WHT='true'">
							<td class="ColValueRec"><xsl:value-of select="mprml:parameterSet[mprml:name='wellhead temperature']/mprml:parameter/mprml:measureValue"/></td>
						</xsl:if>
						<xsl:if test="$HAS_BHP='true'">
							<td class="ColValueRec"><xsl:value-of select="mprml:parameterSet[mprml:name='bottomhole pressure']/mprml:parameter/mprml:measureValue"/></td>
						</xsl:if>
						<xsl:if test="$HAS_BHT='true'">
							<td class="ColValueRec"><xsl:value-of select="mprml:parameterSet[mprml:name='bottomhole temperature']/mprml:parameter/mprml:measureValue"/></td>
						</xsl:if>
						<xsl:if test="$HAS_DSCP='true'">
							<td class="ColValueOpt"><xsl:value-of select="mprml:parameterSet[mprml:name='wellhead pressure DSCP']/mprml:parameter/mprml:measureValue"/></td>
						</xsl:if>
						<xsl:if test="$HAS_DSCT='true'">
							<td class="ColValueOpt"><xsl:value-of select="mprml:parameterSet[mprml:name='wellhead temperature DSCT']/mprml:parameter/mprml:measureValue"/></td>
						</xsl:if>
						<xsl:if test="$HAS_ANNULUS='true'">
							<td class="ColValueOpt"><xsl:value-of select="mprml:parameterSet[mprml:name='annulus pressure']/mprml:parameter/mprml:measureValue"/></td>
						</xsl:if>
						<!--just output the oil column if we have any production wells with allocated oil-->
						<xsl:if test="$HAS_OIL='true'">
							<td class="ColValueRec"><xsl:value-of select="mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='oil - net']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td>
						</xsl:if>
						<!--just output the condensate column if we have any production wells with allocated condensate-->
						<xsl:if test="$HAS_CONDENSATE='true'">
							<td class="ColValueRec"><xsl:value-of select="mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='condensate - net']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td>
						</xsl:if>
						<!--just output the gas column if we have any production wells with allocated gas-->
						<xsl:if test="$HAS_GAS='true'">
							<td class="ColValueRec"><xsl:value-of select="mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='gas']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td>
						</xsl:if>
						<!--just output the water column if we have any production wells with allocated water-->
						<xsl:if test="$HAS_WATER='true'">
							<td class="ColValueRec"><xsl:value-of select="mprml:flow[mprml:kind='production']/mprml:product[mprml:kind='water']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td>
						</xsl:if>
						<xsl:if test="$HAS_GL='true'">
							<td class="ColValueOpt"><xsl:value-of select="mprml:flow[mprml:kind='gas lift']/mprml:product[mprml:kind='gas']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td><!--output gaslift-->
						</xsl:if>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		
	</xsl:template>
	
	
	<xsl:template name="BUILD_INJ_WELLS_TABLE">
	    <xsl:variable name="HAS_BHP"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='injection']/mprml:parameterSet[mprml:name='bottomhole pressure']"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_BHT"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='injection']/mprml:parameterSet[mprml:name='bottomhole temperature']"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_WHP"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='injection']/mprml:parameterSet[mprml:name='wellhead pressure']"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_WHT"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='injection']/mprml:parameterSet[mprml:name='wellhead temperature']"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_CHOKE"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='injection']/mprml:parameterSet[mprml:name='choke size']"><xsl:value-of select="true()"/></xsl:if></xsl:variable>
			<xsl:variable name="HAS_GAS"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow[mprml:kind='injection']/mprml:product[mprml:kind='gas']]">true</xsl:if></xsl:variable>
			<xsl:variable name="HAS_WATER"><xsl:if test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow[mprml:kind='injection']/mprml:product[mprml:kind='water']]">true</xsl:if></xsl:variable>
		<table id="prodWellsTable">
			<xsl:attribute name="class"><xsl:value-of select="$INJ_WELLS_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead">Well / Wellbore</th>
					<th class="ColHead">Uptime</th>
					<xsl:if test="$HAS_CHOKE='true'">
						<th class="ColHeadRec">Choke</th>
					</xsl:if>
					<xsl:if test="$HAS_WHP='true'">
						<th class="ColHeadRec">WHP</th>
					</xsl:if>
					<xsl:if test="$HAS_WHT='true'">
						<th class="ColHeadOpt">WHT</th>
					</xsl:if>
					<xsl:if test="$HAS_BHP='true'">
						<th class="ColHeadOpt">BHP</th>
					</xsl:if>
					<xsl:if test="$HAS_BHT='true'">
						<th class="ColHeadOpt">BHT</th>
					</xsl:if>
					<xsl:if test="$HAS_GAS='true'">
						<th class="ColHeadRec">Gas</th>
					</xsl:if>
					<xsl:if test="$HAS_WATER='true'">
						<th class="ColHeadRec">Water</th>
					</xsl:if>
				    
					
				</tr>
				<tr>
				
					<th class="ColHeadUom"></th>
				
					<th class="ColHeadUom"><xsl:choose>
						<xsl:when test="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='injection']/mprml:parameterSet[mprml:name='facility uptime']"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:parameterSet[mprml:name='facility uptime']/mprml:parameter/mprml:measureValue/@uom[1]"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='injection']/mprml:operationTime/@uom[1]"/></xsl:otherwise>
					</xsl:choose></th>
					<xsl:if test="$HAS_CHOKE='true'">
						<th class="ColHeadUomRec"></th>
					</xsl:if>
					<xsl:if test="$HAS_WHP='true'">
						<th class="ColHeadUomRec"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='injection']/mprml:parameterSet[mprml:name='wellhead pressure']/mprml:parameter/mprml:measureValue/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_WHT='true'">
						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='injection']/mprml:parameterSet[mprml:name='wellhead temperature']/mprml:parameter/mprml:measureValue/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_BHP='true'">
						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='injection']/mprml:parameterSet[mprml:name='bottomhole pressure']/mprml:parameter/mprml:measureValue/@uom[1]"/></th>
					</xsl:if>
					<xsl:if test="$HAS_BHT='true'">
						<th class="ColHeadUomOpt"><xsl:value-of select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']][mprml:flow/mprml:kind='injection']/mprml:parameterSet[mprml:name='bottomhole temperature']/mprml:parameter/mprml:measureValue/@uom[1]"/></th>
					</xsl:if>
			
					
					<xsl:if test="$HAS_GAS='true'">
							<th class="ColHeadUomRec"><xsl:call-template name="BUILD_UOM_FOR_VOLUME">
								<xsl:with-param name="UNIT" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='injection']/mprml:product[mprml:kind='gas']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
								<xsl:with-param name="PRES" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='injection']/mprml:product[mprml:kind='gas']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
								<xsl:with-param name="TEMP" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='injection']/mprml:product[mprml:kind='gas']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
						</xsl:call-template></th>
						</xsl:if>
						<xsl:if test="$HAS_WATER='true'">
							<th class="ColHeadUomRec"><xsl:call-template name="BUILD_UOM_FOR_VOLUME">
								<xsl:with-param name="UNIT" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='injection']/mprml:product[mprml:kind='water']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume/@uom"/>
								<xsl:with-param name="PRES" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='injection']/mprml:product[mprml:kind='water']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:pres"/>
								<xsl:with-param name="TEMP" select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='injection']/mprml:product[mprml:kind='water']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:temp"/>
						</xsl:call-template></th>
						</xsl:if>
					
				
				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="//mprml:facility[mprml:name[@kind='wellbore' or @kind='well']]/mprml:flow[mprml:kind='injection'][mprml:product[mprml:period/mprml:kind='day']]">
				    <xsl:sort select="../mprml:qualifier"/>
				    <xsl:sort select="mprml:name"/>
					<tr>
						<td class="ColValueTxt"><xsl:value-of select="../mprml:name"/></td>
						<td class="ColValue"><xsl:choose>
							<xsl:when test="../mprml:parameterSet[mprml:name='facility uptime']"><xsl:value-of select="../mprml:parameterSet[mprml:name='facility uptime']/mprml:parameter/mprml:measureValue"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="../mprml:operationTime"/></xsl:otherwise>
						</xsl:choose></td>
						<xsl:if test="$HAS_CHOKE='true'">
							<td class="ColValueRec"><xsl:value-of select="../mprml:parameterSet[mprml:name='choke size']/mprml:parameter/mprml:measureValue"/><xsl:text> </xsl:text><xsl:value-of select="../mprml:parameterSet[mprml:name='choke size']/mprml:parameter/mprml:measureValue/@uom"/></td>
						</xsl:if>
						<xsl:if test="$HAS_WHP='true'">
							<td class="ColValueRec"><xsl:value-of select="../mprml:parameterSet[mprml:name='wellhead pressure']/mprml:parameter/mprml:measureValue"/></td>
						</xsl:if>
						<xsl:if test="$HAS_WHT='true'">
							<td class="ColValueOpt"><xsl:value-of select="../mprml:parameterSet[mprml:name='wellhead temperature']/mprml:parameter/mprml:measureValue"/></td>
						</xsl:if>
						<xsl:if test="$HAS_BHP='true'">
							<td class="ColValueOpt"><xsl:value-of select="../mprml:parameterSet[mprml:name='bottomhole pressure']/mprml:parameter/mprml:measureValue"/></td>
						</xsl:if>
						<xsl:if test="$HAS_BHT='true'">
							<td class="ColValueOpt"><xsl:value-of select="../mprml:parameterSet[mprml:name='bottomhole temperature']/mprml:parameter/mprml:measureValue"/></td>
						</xsl:if>
						<xsl:if test="$HAS_GAS='true'">
							<td class="ColValueRec"><xsl:value-of select="mprml:product[mprml:kind='gas']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td>
						</xsl:if>
						<xsl:if test="$HAS_WATER='true'">
							<td class="ColValueRec"><xsl:value-of select="mprml:product[mprml:kind='water']/mprml:period[mprml:kind='day']/mprml:volumeValue/mprml:volume"/></td>
						</xsl:if>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		
	</xsl:template>
    
    <xsl:template name="OUTPUT_SECTION">
    	<xsl:param name="SECTION_TXT"/>
    	<div class="columns dpr20-report-grid">
    		<div class="column" >
    			<p align="left" class="DPR20-ReportSectionTxt"><xsl:value-of select="$SECTION_TXT"/></p>
    		</div>
    	</div>
    	
    </xsl:template>
	
	<xsl:template name="OUTPUT_SUB_SECTION">
		<xsl:param name="SECTION_SUB_TXT"/>
		<div class="columns dpr20-report-subsection">
			<div class="column" >
				<p align="left" class="DPR20-ReportSubSectionTxt"><xsl:value-of select="$SECTION_SUB_TXT"/></p>
			</div>
		</div>
		
	</xsl:template>
    
    <xsl:template name="REPORT_INFO_TABLE_DATA">
		<table id="reportInfoTable">
				<xsl:attribute name="class"><xsl:value-of select="$REPORT_INFO_TABLE_CLASS"/></xsl:attribute>
				 <thead>
					<tr>
					  <th class="ColHead">Asset name</th>
					  <th class="ColHead">Operator</th>
					  <th class="ColHead">Report version</th>
					    <th class="ColHead">Report status</th>
					   <th class="ColHead">Issue date</th>
					   <th class="ColHead">Approved by</th>
					    <th class="ColHead">Approval date</th>
					  
					</tr>
				 </thead>
				<tbody>
							<tr>
							  
							   <td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:installation"/></td>
							
								<td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:operator/mprml:name"/></td>
							
								<td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:reportVersion"/></td>
								<td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:reportStatus"/></td>
							
								<td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:issueDate"/></td>
							
								<td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:approver/mprml:name"/></td>
							
								<td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:approvalDate"/></td>
							</tr>
						
						
				  </tbody>
</table>
    </xsl:template>    
    
    
    
    <xsl:template name="REPORT_INFO_TABLE_DATA_1">
		<table id="reportInfoTable">
				<xsl:attribute name="class"><xsl:value-of select="$REPORT_INFO_TABLE_CLASS"/></xsl:attribute>
				 <thead>
					<tr>
					  <th></th>
					  <th></th>
					 
					  
					</tr>
				 </thead>
				<tbody>
							<tr>
							  <td class="ColHead">Asset type:</td>
							  <td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:installation/@kind"/></td>
							 </tr>
							 <tr>
							   <td class="ColHead">Asset name:</td>
							   <td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:installation"/></td>
							</tr>
							<tr>
								<td class="ColHead">Operator:</td>
								<td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:operator/mprml:name"/></td>
							</tr>
							<tr>
								<td class="ColHead">Report version:</td>
								<td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:reportVersion"/></td>
							</tr>


				  </tbody>
</table>
    </xsl:template>

	<xsl:template name="REPORT_INFO_TABLE_DATA_2">
		<table id="reportInfoTable">
			<xsl:attribute name="class"><xsl:value-of select="$REPORT_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th></th>
					<th></th>
					
					
				</tr>
			</thead>
			<tbody>
				<tr>
					<td class="ColHead">Issue date:</td>
					<td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:issueDate"/></td>
				</tr>
				<tr>
					<td class="ColHead">Approved by:</td>
					<td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:approver/mprml:name"/></td>
				</tr>
				<tr>
					<td class="ColHead">Approval date:</td>
					<td class="ColValue"><xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:approvalDate"/></td>
				</tr>
				<tr>
					<td class="ColHead">File creation date:</td>
					<td class="ColValue"><xsl:call-template name="OUTPUT_DTIM"><xsl:with-param name="DTIM" select="//mprml:FileCreationInformation/mprml:FileCreationDate"></xsl:with-param></xsl:call-template></td>
				</tr>
				
			</tbody>
		</table>
	</xsl:template>
    
	<xsl:template name="OUTPUT_BOOL_VALUE">
		<xsl:param name="VALUE"/>
		<xsl:choose>
			<xsl:when test="$VALUE=''"></xsl:when>
			<xsl:when test="$VALUE='0' or $VALUE='false'">N</xsl:when>
			<xsl:when test="$VALUE='1' or $VALUE='true'">Y</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<xsl:template name="BUILD_HEADER">
		   <div class="columns">
				<div class="column"/>
		    </div>
			<div class="columns dpr20-report-grid">
				<div class="column" >
					<p align="left" class="DPR20-ReportHeader"><xsl:value-of select="//mprml:documentInfo/mprml:DocumentName"/></p>
				</div>
			</div>
			<div class="columns dpr20-report-grid">
					<!--<div class="column is-one-third">
						<p align="left" class="DPR20-SubReportHeader">
							<b>Asset: </b>
							<xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:installation"/>
						</p>
					</div>
					<div class="column is-two-thirds">
						<p align="right" class="DPR20-SubReportHeader">
							<b>Production day: </b>
							<xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:date"/>
						</p>
					</div>-->
					<div class="column">
						<p align="left" class="DPR20-SubReportHeader">
							<b>Asset: </b>
							<xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:installation"/>
						</p>
						<p align="right" class="DPR20-SubReportHeader">
							<b>Production day: </b>
							<xsl:value-of select="//mprml:context[@xsi:type='obj_report']/mprml:date"/>
						</p>
					</div>
		    </div>
		
	
	
		
	</xsl:template>
	
	
</xsl:stylesheet>
