<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0" exclude-result-prefixes="xsd">
	<xsl:output method="html" indent="yes"/>
	<xsl:param name="TABLE_STYLE_CLASS">table is-striped is-narrow mprml-grid</xsl:param>
	<xsl:param name="BULMA_VERSION">0.7.1</xsl:param>
	<xsl:template match="/">
		<xsl:text disable-output-escaping='yes'>&lt;!DOCTYPE html&gt;</xsl:text>
		<html>
			<head>
				<meta charset="utf-8"/>
				<meta name="viewport" content="width=device-width, initial-scale=1"/>
				<link rel="stylesheet">
					<xsl:attribute name="href"><xsl:value-of select="concat('https://cdnjs.cloudflare.com/ajax/libs/bulma/',$BULMA_VERSION,'/css/bulma.min.css')"/></xsl:attribute>
				</link>
				<style type="text/css">
							  
							.Header {
									font-family: Arial Black;
									font-size: 20px;
								}
								.mprml-grid .columns {
									background: #618EB5;
									text-align: left;
									border-radius: 4px;
									text-align: center;
									height: 60px;
									line-height: 60px;
									margin-bottom: .75rem;
									letter-spacing: .1rem;
								}
								.mprml-grid .column {
									background: #618EB5;
									text-align: left;
									border-radius: 4px;
									height: 60px;
									line-height: 60px;
									margin-bottom: .75rem;
									letter-spacing: .1rem;
									 display: flex;
								  flex-direction: column;
								  justify-content: center;
								 
								}
								
								.mprml-data-grid .TextData{
									
									white-space: pre-wrap;
									font-family: Arial;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: left;
								}
								.mprml-data-grid .TextHeader{
									background: #BBB;
									border-radius: 4px;
									font-size: 1rem;
									height: 30px;
									line-height: 30px;
									margin-bottom: .75rem;
									letter-spacing: .1rem;
									font-family: Arial Black;
									font-size: 12px;
								}
								
									.mprml-table .ColValue {
									font-family: Arial;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: left;
								}
								.tab-content {
										display: none;

										.is-active {
										  display: block;
										}
								  }
		  </style>
			</head>
			<body>
				<section class="container">
					<nav class="navbar is-fixed-top is-link">
						<div class="container">
							<div class="navbar-brand">
								
								<a class="navbar-item Header">MPRML and DPR NCS datatransfer standard - documentation of commonly used values</a>
								<span class="navbar-burger burger" data-target="navMenu">
									<span/>
									<span/>
									<span/>
								</span>
							</div>
							<div id="navMenu" class="navbar-menu">
							   <div class="navbar-end">
								<div class="navbar-item has-dropdown is-hoverable ">
									<a class="navbar-link" href="/documentation/overview/start/">Content</a>
									<div class="navbar-dropdown is-boxed">
										<a href="#reportingFacility" class="navbar-item is-active">Facility</a>
										<a href="#reportingFlow" class="navbar-item">Flow kind</a>
										<a href="#reportingFlowQualifier" class="navbar-item">Flow qualifier</a>
										<a href="#reportingPeriod" class="navbar-item">Period kind</a>
										<a href="#reportingProduct" class="navbar-item">Product kind</a>
										<a href="#reportingFlowPart" class="navbar-item">Flow part</a>
										<a href="#facilityParams" class="navbar-item">Facility parameters</a>
									</div>
								</div>
								</div>
							</div>
						</div>
					</nav>
				</section>
				<section class="section">
					<div class="container">
						<div class="container" id="reportingFacility">
						    
							<xsl:call-template name="OUTPUT_ENUMERATIONS">
								<xsl:with-param name="HEADER">Reporting facility</xsl:with-param>
								<xsl:with-param name="SUBTITLE">Describes the valid facilities that can be used for reporting data on a flow.</xsl:with-param>
								<xsl:with-param name="COLUMN1_HEADER">Facility name</xsl:with-param>
								<xsl:with-param name="COLUMN2_HEADER">Facility description</xsl:with-param>
								<xsl:with-param name="XSD_SIMPLETYPE_NAME">ReportingFacility</xsl:with-param>
							</xsl:call-template>
						</div>
						<div class="container" id="reportingFlow">
						   
							<xsl:call-template name="OUTPUT_ENUMERATIONS">
								<xsl:with-param name="HEADER">Reporting flow kinds</xsl:with-param>
								<xsl:with-param name="SUBTITLE">Describes the valid value for the kind of a flow that is reported on.</xsl:with-param>
								<xsl:with-param name="COLUMN1_HEADER">Flow kind</xsl:with-param>
								<xsl:with-param name="COLUMN2_HEADER">Flow kind description</xsl:with-param>
								<xsl:with-param name="XSD_SIMPLETYPE_NAME">ReportingFlow</xsl:with-param>
							</xsl:call-template>
						</div>
						<div class="container" id="reportingFlowQualifier">
							<xsl:call-template name="OUTPUT_ENUMERATIONS">
								<xsl:with-param name="HEADER">Reporting flow qualifier</xsl:with-param>
								<xsl:with-param name="SUBTITLE">Describes the valid value for the reporting qualifier of a flow. The qualifier will describe how the associated measurements where derived e.g. through measuring or derived calculations</xsl:with-param>
								<xsl:with-param name="COLUMN1_HEADER">Flow qualifier</xsl:with-param>
								<xsl:with-param name="COLUMN2_HEADER">Flow qualifier description</xsl:with-param>
								<xsl:with-param name="XSD_SIMPLETYPE_NAME">FlowQualifier</xsl:with-param>
							</xsl:call-template>
						</div>
						<div class="container" id="reportingPeriod">
							<xsl:call-template name="OUTPUT_ENUMERATIONS">
								<xsl:with-param name="HEADER">Reporting flow period kind</xsl:with-param>
								<xsl:with-param name="SUBTITLE">Describes the valid value for the reporting period kind which is used to describe the time period for which the data is reported on</xsl:with-param>
								<xsl:with-param name="COLUMN1_HEADER">Period kind</xsl:with-param>
								<xsl:with-param name="COLUMN2_HEADER">Period kind description</xsl:with-param>
								<xsl:with-param name="XSD_SIMPLETYPE_NAME">ReportingPeriod</xsl:with-param>
							</xsl:call-template>
						</div>
						<div class="container" id="reportingProduct">
							<xsl:call-template name="OUTPUT_ENUMERATIONS">
								<xsl:with-param name="HEADER">Reporting product</xsl:with-param>
								<xsl:with-param name="SUBTITLE">Describes the valid products that can currently be used when reporting on a flow (stream) of e.g. volume data</xsl:with-param>
								<xsl:with-param name="COLUMN1_HEADER">Product name</xsl:with-param>
								<xsl:with-param name="COLUMN2_HEADER">Product description</xsl:with-param>
								<xsl:with-param name="XSD_SIMPLETYPE_NAME">ReportingProduct</xsl:with-param>
							</xsl:call-template>
						</div>
						<div class="container" id="reportingFlowPart">
							<xsl:call-template name="OUTPUT_ENUMERATIONS">
								<xsl:with-param name="HEADER">Reporting balance flow kind</xsl:with-param>
								<xsl:with-param name="SUBTITLE">Describes the valid flow kind that can be used to report on balancing data such as e.g. stock, sale and so on</xsl:with-param>
								<xsl:with-param name="COLUMN1_HEADER">Balance flow kind name</xsl:with-param>
								<xsl:with-param name="COLUMN2_HEADER">Balance flow kind description</xsl:with-param>
								<xsl:with-param name="XSD_SIMPLETYPE_NAME">SalesFlowPart</xsl:with-param>
							</xsl:call-template>
						</div>
						<div class="container" id="facilityParams">
							<xsl:call-template name="OUTPUT_ENUMERATIONS">
								<xsl:with-param name="HEADER">Facility parameters</xsl:with-param>
								<xsl:with-param name="SUBTITLE">Describes the facility parameters that can be used for reporting</xsl:with-param>
								<xsl:with-param name="COLUMN1_HEADER">Facility parameter kind</xsl:with-param>
								<xsl:with-param name="COLUMN2_HEADER">Facility parameter description</xsl:with-param>
								<xsl:with-param name="XSD_SIMPLETYPE_NAME">FacilityParameter</xsl:with-param>
							</xsl:call-template>
						</div>
					</div>
					<footer class="footer">
						<div class="content has-text-centered">
							<p>
								<strong>MPRML</strong> datatransfer standard is managed by <a href="http://www.norog.no">Norsk olje og gass </a>. Any questions can be addressed to the E&amp;P Subsurface domain responsible at <a href="mailto:ep-domain@norog.no">ep-domain@norog.no</a>
							</p>
						</div>
					</footer>
				</section>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="OUTPUT_ENUMERATIONS">
		<xsl:param name="HEADER"/>
		<xsl:param name="SUBTITLE"/>
		<xsl:param name="COLUMN1_HEADER"/>
		<xsl:param name="COLUMN2_HEADER"/>
		<xsl:param name="XSD_SIMPLETYPE_NAME"/>
		<div class="container">
			<br/>
			<br/>
				<br/>
			<br/>
				<br/>
			<br/>
			<div class="columns mprml-grid is-gapless">
				<div class="column">
					<h1 class="title is-6 Header">
						<xsl:value-of select="$HEADER"/>
					</h1>
					<h2 class="subtitle is-6">
						<xsl:value-of select="$SUBTITLE"/>
					</h2>
				</div>
			</div>
			<div class="columns mprml-data-grid">
				<div class="column">
					<table id="dataTable">
						<xsl:attribute name="class"><xsl:value-of select="$TABLE_STYLE_CLASS"/></xsl:attribute>
						<thead>
							<tr>
								<th class="ColHead">
									<xsl:value-of select="$COLUMN1_HEADER"/>
								</th>
								<th class="ColHead">
									<xsl:value-of select="$COLUMN2_HEADER"/>
								</th>
							</tr>
						</thead>
						<xsl:apply-templates select="//xsd:simpleType[@name=$XSD_SIMPLETYPE_NAME]/xsd:restriction/xsd:enumeration">
							<xsl:sort select="@value"/>
						</xsl:apply-templates>
					</table>
				</div>
			</div>
		</div>
	</xsl:template>
	<xsl:template name="OUTPUT_VOLUME_UOMS">
		<br/>
		<br/>
		<h2>Unit of measurement quantifiers</h2>
		<br/>
		<hr/>
		<br/>
		<br/>
		<h3>Reporting Standard Volume UOM (uom quantifiers that can be used in a standard volumne element)</h3>
		<table border="1">
			<tr>
				<td>
					<b>Uom</b>
				</td>
				<td>
					<b>Uom description</b>
				</td>
			</tr>
			<xsl:apply-templates select="//xsd:simpleType[@name='volumeUom']/xsd:restriction/xsd:enumeration">
				<xsl:sort select="@value"/>
			</xsl:apply-templates>
		</table>
	</xsl:template>
	<xsl:template name="OUTPUT_FLOWRATE_UOM">
		<h3>Reporting  Flow Rate UOM (uom quantifiers that can be used in a  flow rate)</h3>
		<table border="1">
			<tr>
				<td>
					<b>Uom</b>
				</td>
				<td>
					<b>Uom description</b>
				</td>
			</tr>
			<xsl:apply-templates select="//xsd:simpleType[@name='volumeFlowRateUom']/xsd:restriction/xsd:enumeration">
				<xsl:sort select="@value"/>
			</xsl:apply-templates>
		</table>
	</xsl:template>
	<xsl:template name="OUTPUT_PRESSURE_UOM">
		<h3>Reporting  Pressure UOM (uom quantifiers that can be used in a  pressure measure)</h3>
		<table border="1">
			<tr>
				<td>
					<b>Uom</b>
				</td>
				<td>
					<b>Uom description</b>
				</td>
			</tr>
			<xsl:apply-templates select="//xsd:simpleType[@name='pressureUom']/xsd:restriction/xsd:enumeration">
				<xsl:sort select="@value"/>
			</xsl:apply-templates>
		</table>
	</xsl:template>
	<xsl:template name="OUTPUT_MASS_UOM">
		<h3>Reporting Mass UOM (uom quantifiers that can be used in a  mass measure)</h3>
		<table border="1">
			<tr>
				<td>
					<b>Uom</b>
				</td>
				<td>
					<b>Uom description</b>
				</td>
			</tr>
			<xsl:apply-templates select="//xsd:simpleType[@name='massUom']/xsd:restriction/xsd:enumeration">
				<xsl:sort select="@value"/>
			</xsl:apply-templates>
		</table>
	</xsl:template>
	<xsl:template name="OUTPUT_TEMP_UOM">
		<h3>Reporting Temperature UOM (uom quantifiers that can be used in a  temp measure)</h3>
		<table border="1">
			<tr>
				<td>
					<b>Uom</b>
				</td>
				<td>
					<b>Uom description</b>
				</td>
			</tr>
			<xsl:apply-templates select="//xsd:simpleType[@name='thermodynamicTemperatureUom']/xsd:restriction/xsd:enumeration">
				<xsl:sort select="@value"/>
			</xsl:apply-templates>
		</table>
	</xsl:template>
	<xsl:template name="OUTPUT_WORK_UOM">
		<h3>Reporting Work UOM (uom quantifiers that can be used in a  work measure)</h3>
		<table border="1">
			<tr>
				<td>
					<b>Uom</b>
				</td>
				<td>
					<b>Uom description</b>
				</td>
			</tr>
			<xsl:apply-templates select="//xsd:simpleType[@name='workUom']/xsd:restriction/xsd:enumeration">
				<xsl:sort select="@value"/>
			</xsl:apply-templates>
		</table>
	</xsl:template>
	<xsl:template match="xsd:enumeration">
		<tr>
			<td class="ColValue">
				<xsl:value-of select="@value"/>
			</td>
			<td class="ColValue">
				<xsl:value-of select="normalize-space(self::node()/xsd:annotation/xsd:documentation)"/>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
