/*
 * Decompiled with CFR 0.152.
 */
package com.epim.ep.standards;

import com.epim.ep.standards.TransformParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class TransformUtils {
    static final String transformerClass = "org.apache.xalan.processor.TransformerFactoryImpl";

    public byte[] transformFile(String xmlFile, String styleSheet, ArrayList<TransformParameter> transformParams) throws TransformerConfigurationException, TransformerException, IOException {
        byte[] inXmlFile = this.file2ByteArray(xmlFile);
        byte[] xslFile = this.file2ByteArray(styleSheet);
        return this.transformData(inXmlFile, xslFile, transformParams);
    }

    public byte[] transformData(byte[] xmlFileArray, byte[] xslFileArray, ArrayList<TransformParameter> transformParams) throws TransformerConfigurationException, TransformerException {
        StreamSource xslSrc = new StreamSource(new ByteArrayInputStream(xslFileArray));
        StreamSource xmlSrc = new StreamSource(new ByteArrayInputStream(xmlFileArray));
        TransformerFactory transformerFactory = TransformerFactory.newInstance(transformerClass, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        Transformer t = transformerFactory.newTransformer(xslSrc);
        if (transformParams != null) {
            for (int i = 0; i <= transformParams.size() - 1; ++i) {
                t.setParameter(transformParams.get((int)i).name, transformParams.get((int)i).value);
            }
        }
        t.transform(xmlSrc, result);
        return baos.toByteArray();
    }

    private byte[] file2ByteArray(String file2Read) throws IOException {
        Path path = Paths.get(file2Read, new String[0]);
        byte[] fileInBytes = Files.readAllBytes(path);
        return fileInBytes;
    }
}

