<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"   xmlns:witsml="http://www.witsml.org/schemas/1series" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"  xmlns:epim="xalan://com.epim.ep.standards.XSDDateHelper" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">

	<xsl:output method="html" encoding="UTF-8" indent="yes"/>
	
	
	<xsl:param name="INCLUDE_ALL_SECTIONS">0</xsl:param><!--if set to 1 it will include all section even though they have no asssociated data-->
	<!-- start of styling parameters for tables-->
	<xsl:param name="WELLBORE_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-wellbore-info-table</xsl:param> <!--used to control style of wellboreinfo tables-->
    <xsl:param name="OPERATIONS_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of operationsinfo tables-->
    <xsl:param name="EQUIPMENT_FAILURE_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of equipment failue info tables-->
    <xsl:param name="BITRECORD_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of bitrecord info tables-->
	<xsl:param name="DRILLING_FLUID_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of drilling fluid info tables-->
    <xsl:param name="POREPRESSURE_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of pore pressure info tables-->
	<xsl:param name="SURVEY_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of survey info tables-->
	<xsl:param name="LOG_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of log info tables-->
	<xsl:param name="CORE_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of core info tables-->
   	<xsl:param name="WELLTEST_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of welltest info tables-->
	<xsl:param name="FORMATION_TEST_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of formationtest info tables-->
     <xsl:param name="STRATIGRAPHIC_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of stratigraphic info tables-->
	 <xsl:param name="LITHOLOGY_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of lithology info tables-->
	 <xsl:param name="WELLCONTROL_INCIDENT_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of wellcontrol incident info tables-->
	 <xsl:param name="PERFORATION_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of perforation incident info tables-->
	 <xsl:param name="GASREADING_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of gas reading info tables-->
	 <xsl:param name="CASING_LINER_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of  casing liner info tables-->
	 <xsl:param name="CEMENT_STAGE_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of  cement stage info tables-->
	 <xsl:param name="CEMENT_FLUID_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of  cement fluid info tables-->
	 <xsl:param name="WEATHER_INFO_TABLE_CLASS">table is-striped is-narrow ddr-report-operations-table</xsl:param> <!--used to control style of  weather info tables-->

    <!--end of table stylings-->
	<xsl:param name="CSS_ROOT"></xsl:param><!-- this parameter can be set from the outside if needed and if null will use CSS from cdnjs.cloudflare.com-->
	<xsl:param name="CSS_ROOT_PATH">
		<xsl:choose>
			<xsl:when test="$CSS_ROOT!=''"><xsl:value-of select="$CSS_ROOT"/></xsl:when>
			<xsl:otherwise>https://cdnjs.cloudflare.com/ajax/libs/bulma/0.7.1/css/</xsl:otherwise>
		</xsl:choose>
	</xsl:param>
	<xsl:template match="/">
	    <xsl:text disable-output-escaping='yes'>&lt;!DOCTYPE html&gt;</xsl:text>
		<html>
			<head>
					<meta charset="utf-8"/>
					<meta name="viewport" content="width=device-width, initial-scale=1"/>
					<link rel="stylesheet" href="{$CSS_ROOT_PATH}bulma.css.map" />
					<link rel="stylesheet" href="{$CSS_ROOT_PATH}bulma.min.css" />
					<style type="text/css">
							  /* set the page size to be A4 at a maximum
*/


/*html,body{
    height:297mm;
    width:210mm;
}*/

@media print and (color)
{*
{
    -webkit-print-color-adjust:exact;
   print-color-adjust:exact;
   tbody {
                page-break-inside: avoid;
            }
            thead {
                display: table-header-group;
                margin-top: 100px;
            }
}}
						    
							
							.wellbore-report-header-table .wellboreName {
									font-family: Arial Black;
									font-size: 12px;
									text-decoration: none;
									color: #000000;
									text-align: left;
								}
							.wellbore-report-header-table .reportingPeriod {
									font-family: Arial Black;
									font-size: 12px;
									text-decoration: none;
									color: #000000;
									text-align: right;
								}
								
							
								.ddr-report-grid .columns {
									background: #BBB;
									text-align: center;
									border-radius: 4px;
									font-size: 1rem;
									text-align: center;
									//height: 30px;
									line-height: 30px;
									margin-bottom: .75rem;
									letter-spacing: .1rem;
								}
								
								.ddr-report-grid .column {
									background: #BBB;
									text-align: center;
									border-radius: 4px;
									font-size: 1rem;
									//height: 30px;
									line-height: 30px;
									margin-bottom: .75rem;
									letter-spacing: .1rem;
									 //display: flex;
								  //flex-direction: column;
								  //justify-content: center;
								 
								}
								
								.DDR-SubReportHeader {
									font-family: Arial Black;
									font-size: 12px;
								}
								
								.DDR-ReportHeader {
									font-family: Arial Black;
									font-size: 16px;
								}
								
								.ddr-report-wellbore-info-table .ColHead {
									font-family: Arial Black;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: right;
								}
								.ddr-report-wellbore-info-table .ColValue {
									font-family: Arial;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: right;
								}
								
								.ddr-report-wellbore-info-table .ColValueTxt {
									font-family: Arial;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: left;
								}
								
								.ddr-report-operations-table .ColHeadRowOriented {
									font-family: Arial Black;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: left;
								  
								}
								
								
								.ddr-report-wellbore-info-table .ColValueWrapped {
									font-family: Arial;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: left;
									white-space: pre-wrap;
								}
								
								.ddr-report-wellbore-info-table .ColValueWrappedTxt {
									font-family: Arial;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: left;
									white-space: pre-wrap;
								}
								/*css data for operations table*/
								.ddr-report-operations-table .ColHead {
									font-family: Arial Black;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: center;
								}
								.ddr-report-operations-table .ColValue {
									font-family: Arial;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: right;
								}
								.ddr-report-operations-table .ColValueTxt {
									font-family: Arial;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: left;
								}
								
								.ddr-report-operations-table .ColValueWrapped {
									font-family: Arial;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: left;
									white-space: pre-wrap;
								}
								
								.ddr-report-operations-table .ColValueWrappedTxt {
									font-family: Arial;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: left;
									white-space: pre-wrap;
								}
								
								.ddr-report-operations-table .tableRowHighlight {
									background: #e6e6e6;
									text-align: center;
									border-radius: 4px;
									border-bottom: 2px solid black !important;
									border-top: 2px solid black !important;
								}
								
								
								/*Set the css for the text data field containing the actual text comments for sections containing e.g. comments data such as summary of activities*/
								.ddr-report-text-data-grid .TextData{
									
									white-space: pre-wrap;
									font-family: Arial;
									font-size: 11px;
									text-decoration: none;
									color: #000000;
									text-align: left;
								}
								/*Set the css for the text header for sections containing e.g. comments data such as summary of activities*/
								.ddr-report-text-data-grid .TextHeader{
									background: #BBB;
									border-radius: 4px;
									font-size: 1rem;
									height: 30px;
									line-height: 30px;
									margin-bottom: .75rem;
									letter-spacing: .1rem;
									font-family: Arial Black;
									font-size: 12px;
								}
								
				   </style>
				
			</head>
			<body>
				<section class="section">
					
						<xsl:for-each select="//witsml:drillReport">
						       <div class="container">
									<xsl:call-template name="BUILD_HEADER"/>
									
							   </div>
							   <div class="container">
								   <xsl:call-template name="BUILD_WELLBORE_INFO"/>
								</div>
								<div class="container">
								   <xsl:call-template name="BUILD_SUMMARY_24HRS"/>
								</div>
								<div class="container">
									   <xsl:call-template name="BUILD_FORECAST_24HRS"/>
								</div>
								<div class="container">
									  <xsl:call-template name="BUILD_EXTENDED_REPORT"/>
								</div>
								<div class="container">
									   <xsl:call-template name="BUILD_OPERATIONS"/>
								</div>
								<div class="container">
									   <xsl:call-template name="BUILD_EQUIPMENT_FAILURE"/>
								</div>
								<div class="container">
									  <xsl:call-template name="BUILD_BIT_RECORD"/>
								</div>
								<div class="container">
									 <xsl:call-template name="BUILD_DRILLING_FLUID_INFO"/>
								</div>
								<div class="container">
									 <xsl:call-template name="BUILD_PORE_PRESSURE"/>
								</div>
								<div class="container">
								   <xsl:call-template name="BUILD_SURVEY_STATION"/>
								</div>
								<div class="container">
									   <xsl:call-template name="BUILD_LOG_INFORMATION"/>
								</div>
								<div class="container">
								   <xsl:call-template name="BUILD_CORE_INFORMATION"/>
								</div>
								<div class="container">
									  <xsl:call-template name="BUILD_WELLTEST_INFORMATION"/>
								</div>
								<div class="container">
									   <xsl:call-template name="BUILD_FORMATION_TEST"/>
								</div>
								<div class="container">
									   <xsl:call-template name="BUILD_STRATIGRAPHIC_INFO"/>
								</div>
								<div class="container">
									   <xsl:call-template name="BUILD_LITHOLOGY_INFO"/>
								</div>
								<div class="container">
									  <xsl:call-template name="BUILD_WELLCONTROL_INCIDENT"/>
								</div>
								<div class="container">
									 <xsl:call-template name="BUILD_PERFORATION_INFO"/>
								</div>
								<div class="container">
									  <xsl:call-template name="BUILD_GAS_READING_INFO"/>
								</div>
								<div class="container">
									<xsl:call-template name="BUILD_CASING_LINER_INFO"/>
								</div>
								<div class="container">
									  <xsl:call-template name="BUILD_CEMENT_STAGE_INFO"/>
								</div>
								<div class="container">
									  <xsl:call-template name="BUILD_CEMENT_FLUID_INFO"/>
								</div>
								<div class="container">
									  <xsl:call-template name="BUILD_WEATHER_INFO"/>
								</div>
						</xsl:for-each>
				</section>
				
			</body>
		</html>
	</xsl:template>
	
	
	<xsl:template name="TIME_FROM_DATETIME">
	<xsl:param name="DATETIME"/>
	<xsl:choose>
		<xsl:when test="$DATETIME!=''"><xsl:value-of select="epim:DateTime2LocalTime($DATETIME,'HH:mm')"/></xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
	</xsl:template>
	
	<xsl:template name="DATE_AND_TIME_FROM_DATETIME">
	
	<xsl:param name="DATETIME"/>
	<xsl:choose>
		<xsl:when test="$DATETIME!=''"><xsl:value-of select="epim:DateTime2LocalTime($DATETIME,'YYYY-MM-dd HH:mm')"/></xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
  
	</xsl:template>
	
    <xsl:template name="BUILD_WELLBORE_INFO">
       
		<div class="columns">
			
				<!--<div class="column"><xsl:call-template name="WELLBORE_INFO_TABLE_DATA_1"/></div>
				<div class="column"><xsl:call-template name="WELLBORE_INFO_TABLE_DATA_2"/></div>-->
				<div class="column">
					<table width="100%">
						<tbody>
							<tr>
								<td align="left" width="50%"><xsl:call-template name="WELLBORE_INFO_TABLE_DATA_1"/></td>
								<td align="left" width="50%"><xsl:call-template name="WELLBORE_INFO_TABLE_DATA_2"/></td>
							</tr>
						</tbody>
					</table>
				</div>
	
		
		</div>
    
    </xsl:template>	
    
    
    <xsl:template name="BUILD_SUMMARY_24HRS">
    <xsl:if test="witsml:statusInfo/witsml:sum24Hr or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
				<div class="column">
					<p align="left" class="TextHeader">Summary of activities (24 Hours)</p>
				</div>
	    </div>
       <div class="columns ddr-report-text-data-grid">
				<div class="column">
					<p align="left" class="TextData"><xsl:value-of select="witsml:statusInfo/witsml:sum24Hr"/></p>
				</div>
			</div>
	</xsl:if>
    </xsl:template>
    
    <xsl:template name="BUILD_EXTENDED_REPORT">
    <xsl:if test="witsml:extendedReport or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
				<div class="column">
					<p align="left" class="TextHeader">Extended report</p>
				</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
				<div class="column">
					<p align="left" class="TextData"><xsl:value-of select="witsml:extendedReport"/></p>
				</div>
			</div>
	</xsl:if>
    </xsl:template>
    
     <xsl:template name="BUILD_FORECAST_24HRS">
     <xsl:if test="witsml:statusInfo/witsml:forecast24Hr or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
				<div class="column">
					<p align="left" class="TextHeader">Summary of planned activities (24 Hours)</p>
				</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
				<div class="column">
					<p align="left" class="TextData"><xsl:value-of select="witsml:statusInfo/witsml:forecast24Hr"/></p>
				</div>
			</div>
	</xsl:if>
    </xsl:template>
	
	<xsl:template name="BUILD_LOG_INFORMATION">
	 <xsl:if test="witsml:logInfo or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Log Information</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_LOG_INFORMATION_TABLE"/>
			</div>
		</div>
	</xsl:if>
	</xsl:template>
	
	<xsl:template name="BUILD_DRILLING_FLUID_INFO">
   <xsl:if test="witsml:fluid or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Drilling Fluid</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				
					<xsl:call-template name="BUILD_DRILLING_FLUID_INFO_TABLE"/>
				
			</div>
		</div>
		<!--add rheometers if existing-->
		<xsl:if test="witsml:fluid/witsml:rheometer or $INCLUDE_ALL_SECTIONS='1'">
			<div class="columns ddr-report-text-data-grid">
				<div class="column">
					
						<xsl:call-template name="BUILD_DRILLING_FLUID_RHEOMETER_TABLE"/>
					
				</div>
			</div>
			</xsl:if>
	</xsl:if>
	</xsl:template>
	
	
	<xsl:template name="BUILD_DRILLING_FLUID_INFO_TABLE">
		<table id="drillingFluidTable">
			<xsl:attribute name="class"><xsl:value-of select="$DRILLING_FLUID_INFO_TABLE_CLASS"/></xsl:attribute>
			<tbody>
			    <!--first build all of the entries flat-->
			    <tr>
					<td  class="ColHeadRowOriented">Sample Time</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTim"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Sample Point</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValueTxt"><xsl:value-of select="witsml:locationSample"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Sample Depth <xsl:value-of select="(witsml:fluid/witsml:md/@uom)[1]"/>MD</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:md"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Fluid Type</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValueTxt"><xsl:value-of select="witsml:type"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Fluid Density (<xsl:value-of select="(witsml:fluid/witsml:density/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:density"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Funnel Visc (<xsl:value-of select="(witsml:fluid/witsml:visFunnel/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:visFunnel"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Mf (<xsl:value-of select="(witsml:fluid/witsml:mf/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:mf"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Pm (<xsl:value-of select="(witsml:fluid/witsml:pm/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:pm"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Pm filtrate (<xsl:value-of select="(witsml:fluid/witsml:pmFiltrate/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:pmFiltrate"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Chloride (<xsl:value-of select="(witsml:fluid/witsml:chloride/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:chloride"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Calcium (<xsl:value-of select="(witsml:fluid/witsml:calcium/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:calcium"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Magnesium (<xsl:value-of select="(witsml:fluid/witsml:magnesium/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:magnesium"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Ph</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:ph"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Excess Lime (<xsl:value-of select="(witsml:fluid/witsml:lime/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:lime"/></td>
					</xsl:for-each>
				</tr>
				<tr class="tableRowHighlight">
					<td  class="ColHeadRowOriented">
						<xsl:attribute name="colSpan"><xsl:value-of select="count(witsml:fluid)+1"/></xsl:attribute>
					Solids</td>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Sand (<xsl:value-of select="(witsml:fluid/witsml:sandPc/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:sandPc"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Water (<xsl:value-of select="(witsml:fluid/witsml:waterPc/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:waterPc"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Oil (<xsl:value-of select="(witsml:fluid/witsml:oilPc/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:oilPc"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Solids (<xsl:value-of select="(witsml:fluid/witsml:solidsPc/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:solidsPc"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Corrected solids (<xsl:value-of select="(witsml:fluid/witsml:solCorPc/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:solCorPc"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">High gravity solids (<xsl:value-of select="(witsml:fluid/witsml:solidsHiGravPc/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:solidsHiGravPc"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Low gravity solids (<xsl:value-of select="(witsml:fluid/witsml:solidsLowGravPc/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:solidsLowGravPc"/></td>
					</xsl:for-each>
				</tr>
				<tr class="tableRowHighlight">
					<td  class="ColHeadRowOriented">
						<xsl:attribute name="colSpan"><xsl:value-of select="count(witsml:fluid)+1"/></xsl:attribute>
					Viscometer tests</td>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Plastic visc. (<xsl:value-of select="(witsml:fluid/witsml:pv/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:pv"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Yield point (<xsl:value-of select="(witsml:fluid/witsml:yp/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:yp"/></td>
					</xsl:for-each>
				</tr>
				<tr class="tableRowHighlight">
					<td  class="ColHeadRowOriented">
						<xsl:attribute name="colSpan"><xsl:value-of select="count(witsml:fluid)+1"/></xsl:attribute>
					Filtration tests</td>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Pm filtrate (<xsl:value-of select="(witsml:fluid/witsml:pmFiltrate/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:pmFiltrate"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Filtrate Lthp (<xsl:value-of select="(witsml:fluid/witsml:filtrateLtlp/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:filtrateLtlp"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Filtrate Hthp (<xsl:value-of select="(witsml:fluid/witsml:filtrateHthp/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:filtrateHthp"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Cake thickn API (<xsl:value-of select="(witsml:fluid/witsml:filterCakeLtlp/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:filterCakeLtlp"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Cake thickn HPHT (<xsl:value-of select="(witsml:fluid/witsml:filterCakeHthp/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:filterCakeHthp"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Test Temp HPHT (<xsl:value-of select="(witsml:fluid/witsml:tempHthp/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:tempHthp"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Comment</td>
					<xsl:for-each select="witsml:fluid">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValueTxt"><xsl:value-of select="witsml:comments"/></td>
					</xsl:for-each>
				</tr>
			</tbody>
		</table>
	</xsl:template>   	
	
 	<xsl:template name="BUILD_DRILLING_FLUID_RHEOMETER_TABLE">
		<table id="drillingFluidRheometerTable">
			<xsl:attribute name="class"><xsl:value-of select="$DRILLING_FLUID_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead">Sample time</th>
					<th class="ColHead">Sample point</th>
					<th class="ColHead">Sample depth <xsl:value-of select="(witsml:fluid/witsml:md/@uom)[1]"/>MD</th>
					<th class="ColHead">Rheometer pressure (<xsl:value-of select="(witsml:fluid/witsml:rheometer/witsml:presRheom/@uom)[1]"/>)</th>
					<th class="ColHead">Rheometer temperature (<xsl:value-of select="(witsml:fluid/witsml:rheometer/witsml:tempRheom/@uom)[1]"/>)</th>
					<th class="ColHead">3 Rpm</th>
					<th class="ColHead">6 Rpm</th>
					<th class="ColHead">30 Rpm</th>
					<th class="ColHead">60 Rpm</th>
					<th class="ColHead">100 Rpm</th>
					<th class="ColHead">200 Rpm</th>
					<th class="ColHead">300 Rpm</th>
					<th class="ColHead">600 Rpm</th>


				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:fluid/witsml:rheometer">
					<xsl:sort select="../witsml:dTim"/>
					<tr>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="../witsml:dTim"/></xsl:call-template></td>
						<td class="ColValueTxt"><xsl:value-of select="../witsml:locationSample"/></td>
						<td class="ColValue"><xsl:value-of select="../witsml:md"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:presRheom"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tempRheom"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:vis3Rpm"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:vis6Rpm"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:vis30Rpm"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:vis60Rpm"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:vis100Rpm"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:vis200Rpm"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:vis300Rpm"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:vis600Rpm"/></td>
			    	</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    				
	
	
	
  <xsl:template name="BUILD_WEATHER_INFO">
   <xsl:if test="witsml:weather or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Weather</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				
					<xsl:call-template name="BUILD_WEATHER_INFO_TABLE"/>
				
			</div>
		</div>
	</xsl:if>
	</xsl:template>
	
	
	<xsl:template name="BUILD_WEATHER_INFO_TABLE">
		<table id="weatherInfoTable">
			<xsl:attribute name="class"><xsl:value-of select="$WEATHER_INFO_TABLE_CLASS"/></xsl:attribute>
			<tbody>
			    <!--first build all of the entries flat-->
			    <tr>
					<td  class="ColHeadRowOriented">Time</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTim"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Company</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValueTxt"><xsl:value-of select="witsml:agency"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Barometric Pressure (<xsl:value-of select="(witsml:weather/witsml:barometricPressure/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:barometricPressure"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Beaufort scale number</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:beaufortScaleNumber"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Surface Temperature - min (<xsl:value-of select="(witsml:weather/witsml:tempSurfaceMn/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:tempSurfaceMn"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Surface Temperature - max (<xsl:value-of select="(witsml:weather/witsml:tempSurfaceMx/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:tempSurfaceMx"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Temperature - wind chill (<xsl:value-of select="(witsml:weather/witsml:tempWindChill/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:tempWindChill"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Temperature - sea (<xsl:value-of select="(witsml:weather/witsml:tempsea/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:tempsea"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Visibility (<xsl:value-of select="(witsml:weather/witsml:visibility/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:visibility"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Wave - direction (<xsl:value-of select="(witsml:weather/witsml:aziWave/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:aziWave"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Wave - avg. height (<xsl:value-of select="(witsml:weather/witsml:htWave/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:htWave"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Wave - significant (<xsl:value-of select="(witsml:weather/witsml:significantWave/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:significantWave"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Wave - max height (<xsl:value-of select="(witsml:weather/witsml:maxWave/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:maxWave"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Wave - period (<xsl:value-of select="(witsml:weather/witsml:periodWave/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:periodWave"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Wind - direction (<xsl:value-of select="(witsml:weather/witsml:aziWind/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:aziWind"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Wind - speed (<xsl:value-of select="(witsml:weather/witsml:velWind/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:velWind"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Precipitation type</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValueTxt"><xsl:value-of select="witsml:typePrecip"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Precipitation - amount (<xsl:value-of select="(witsml:weather/witsml:amtPrecip/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:amtPrecip"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Cloud - cover</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:coverCloud"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Cloud - cover height (<xsl:value-of select="(witsml:weather/witsml:ceilingCloud/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:ceilingCloud"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Current sea (<xsl:value-of select="(witsml:weather/witsml:currentSea/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:currentSea"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Current sea - azimuth (<xsl:value-of select="(witsml:weather/witsml:aziCurrentSea/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValue"><xsl:value-of select="witsml:aziCurrentSea"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Comments</td>
					<xsl:for-each select="witsml:weather">
						<xsl:sort select="witsml:dTim"/>
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:comments"/></td>
					</xsl:for-each>
				</tr>
				
			</tbody>
		</table>
	</xsl:template>   	
	
	
 <xsl:template name="BUILD_CEMENT_STAGE_INFO">
   <xsl:if test="witsml:cementStage or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Cement</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				
					<xsl:call-template name="BUILD_CEMENT_STAGE_INFO_TABLE"/>
				
			</div>
		</div>
	</xsl:if>
	</xsl:template>
	
	
	<xsl:template name="BUILD_CEMENT_STAGE_INFO_TABLE">
		<table id="cementStageTable">
			<xsl:attribute name="class"><xsl:value-of select="$CEMENT_STAGE_INFO_TABLE_CLASS"/></xsl:attribute>
			<tbody>
			    <!--first build all of the entries flat-->
			    <tr>
					<td  class="ColHeadRowOriented">Start Time</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTimPumpStart"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">End Time</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTimPumpEnd"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Job Type</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValueTxt"><xsl:value-of select="witsml:jobType"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Casing String Diameter (<xsl:value-of select="(witsml:cementStage/witsml:casingStrDia/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValue"><xsl:value-of select="witsml:casingStrDia"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Top Plug Used </td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValueTxt"><xsl:call-template name="OUTPUT_BOOL_VALUE"><xsl:with-param name="VALUE" select="witsml:topPlug"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Bottom Plug Used </td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValueTxt"><xsl:call-template name="OUTPUT_BOOL_VALUE"><xsl:with-param name="VALUE" select="witsml:botPlug"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Plug Bumped</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValueTxt"><xsl:call-template name="OUTPUT_BOOL_VALUE"><xsl:with-param name="VALUE" select="witsml:plugBumped"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Plug Bum Pressure (<xsl:value-of select="(witsml:cementStage/witsml:presBump/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValue"><xsl:value-of select="witsml:presBump"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Float Held</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValueTxt"><xsl:call-template name="OUTPUT_BOOL_VALUE"><xsl:with-param name="VALUE" select="witsml:floatHeld"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Pressure Release Time</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTimPresReleased"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Full Returns</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValueTxt"><xsl:call-template name="OUTPUT_BOOL_VALUE"><xsl:with-param name="VALUE" select="witsml:annFlowAfter"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Cement Volume Returns (<xsl:value-of select="(witsml:cementStage/witsml:volReturns/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValue"><xsl:value-of select="witsml:volReturns"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Reciprocated</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValueTxt"><xsl:call-template name="OUTPUT_BOOL_VALUE"><xsl:with-param name="VALUE" select="witsml:reciprocated"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Rotated</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValueTxt"><xsl:call-template name="OUTPUT_BOOL_VALUE"><xsl:with-param name="VALUE" select="witsml:rotated"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Comment</td>
					<xsl:for-each select="witsml:cementStage">
						<xsl:sort select="witsml:dTimPumpStart"/>
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:comments"/></td>
					</xsl:for-each>
				</tr>
				
			</tbody>
		</table>
	</xsl:template>    	
	
	
	<xsl:template name="BUILD_CEMENT_FLUID_INFO">
   <xsl:if test="witsml:controlIncidentInfo or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Cement Fluid</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_CEMENT_FLUID_INFO_TABLE"/>
			</div>
		</div>
	</xsl:if>
	</xsl:template>
	
	<xsl:template name="BUILD_CEMENT_FLUID_INFO_TABLE">
		<table id="casingLinerTable">
			<xsl:attribute name="class"><xsl:value-of select="$CEMENT_FLUID_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead">Start Time</th>
					<th class="ColHead">End Time</th>
					<th class="ColHead">Job Type</th>
					<th class="ColHead">Fluid Type</th>
					<th class="ColHead">Volume Pumped (<xsl:value-of select="(witsml:cementStage/witsml:cementingFluid/witsml:volPumped/@uom)[1]"/>)</th>
					<th class="ColHead">Fluid Density (<xsl:value-of select="(witsml:cementStage/witsml:cementingFluid/witsml:density/@uom)[1]"/>)</th>
					<th class="ColHead">Yield Point (<xsl:value-of select="(witsml:cementStage/witsml:cementingFluid/witsml:yp/@uom)[1]"/>)</th>
					<th class="ColHead">Mix Water Ratio (<xsl:value-of select="(witsml:cementStage/witsml:cementingFluid/witsml:ratioMixWater/@uom)[1]"/>)</th>
					<th class="ColHead">Free Water (<xsl:value-of select="(witsml:cementStage/witsml:cementingFluid/witsml:pcFreeWater/@uom)[1]"/>)</th>
					<th class="ColHead">Thickening Time (<xsl:value-of select="(witsml:cementStage/witsml:cementingFluid/witsml:eTimThickening/@uom)[1]"/>)</th>
					<th class="ColHead">Fluid Description</th>
					<th class="ColHead">Comment</th>

				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:cementStage/witsml:cementingFluid">
					<xsl:sort select="../witsml:dTimPumpStart"/>
					<tr>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="../witsml:dTimPumpStart"/></xsl:call-template></td>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="../witsml:dTimPumpEnd"/></xsl:call-template></td>
						<td class="ColValueTxt"><xsl:value-of select="../witsml:jobType"/></td>
						<td class="ColValueTxt"><xsl:value-of select="witsml:typeFluid"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:volPumped"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:density"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:yp"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:ratioMixWater"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:pcFreeWater"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:eTimThickening"/></td>
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:descFluid"/></td>
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:comments"/></td>
			    	</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    				
	
	<xsl:template name="BUILD_CASING_LINER_INFO">
   <xsl:if test="witsml:casing_liner_tubing or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Casing Liner Tubing</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_CASING_LINER_INFO_TABLE"/>
			</div>
		</div>
	</xsl:if>
	</xsl:template>
	
		

<xsl:template name="BUILD_CASING_LINER_INFO_TABLE">
		<table id="casingLinerInfoTable">
			<xsl:attribute name="class"><xsl:value-of select="$CASING_LINER_INFO_TABLE_CLASS"/></xsl:attribute>
			<tbody>
			    <!--first build all of the entries flat-->
			    <tr>
					<td  class="ColHeadRowOriented">Start Time</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					     <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>

						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:casing_liner_tubing_run/witsml:dTimStart"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">End Time</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					   	<xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>

						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:casing_liner_tubing_run/witsml:dTimEnd"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Type of Pipe</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					    <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>

						<td class="ColValueTxt"><xsl:call-template name="MAP_CASING_TUBING_TYPE"><xsl:with-param name="TYPE" select="witsml:type"/></xsl:call-template></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Casing Type</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					    <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>
						<td class="ColValueTxt"><xsl:value-of select="witsml:casing_liner_tubing_run/witsml:casingType"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Outside diameter (<xsl:value-of select="(witsml:casing_liner_tubing/witsml:od/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					    <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>
						<td class="ColValue"><xsl:value-of select="witsml:od"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Inside diameter (<xsl:value-of select="(witsml:casing_liner_tubing/witsml:id/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					   <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>
						<td class="ColValue"><xsl:value-of select="witsml:id"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Weight (<xsl:value-of select="(witsml:casing_liner_tubing/witsml:weight/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					    <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>
						<td class="ColValue"><xsl:value-of select="witsml:weight"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Grade</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					   <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>
						<td class="ColValueWrapped"><xsl:value-of select="witsml:grade"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Connection</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					    <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:connection"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Length (<xsl:value-of select="(witsml:casing_liner_tubing/witsml:length/@uom)[1]"/>)</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					    <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>
						<td class="ColValue"><xsl:value-of select="witsml:length"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Top <xsl:value-of select="(witsml:casing_liner_tubing/witsml:mdTop/@uom)[1]"/>MD</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					    <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>
						<td class="ColValue"><xsl:value-of select="witsml:mdTop"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Bottom <xsl:value-of select="(witsml:casing_liner_tubing/witsml:mdBottom/@uom)[1]"/>MD</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					    <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>
						<td class="ColValue"><xsl:value-of select="witsml:mdBottom"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Description</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					   <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:casing_liner_tubing_run/witsml:description"/></td>
					</xsl:for-each>
				</tr>
				<tr>
					<td  class="ColHeadRowOriented">Comment</td>
					<xsl:for-each select="witsml:casing_liner_tubing">
					    <xsl:sort select="witsml:casing_liner_tubing_run/witsml:dTimStart" case-order="lower-first"/>
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:comment"/></td>
					</xsl:for-each>
				</tr>
				
			</tbody>
		</table>
	</xsl:template>   	


  <xsl:template name="MAP_CASING_TUBING_TYPE">
<xsl:param name="TYPE"/>
<xsl:choose>
	<xsl:when test="$TYPE='t'">Tubing</xsl:when>
	<xsl:when test="$TYPE='c'">Casing</xsl:when>
	<xsl:when test="$TYPE='l'">Liner</xsl:when>
	<xsl:otherwise>Unknown casing tubing type:<xsl:value-of select="$TYPE"/></xsl:otherwise>
</xsl:choose>  
  </xsl:template>
	
  <xsl:template name="BUILD_WELLCONTROL_INCIDENT">
   <xsl:if test="witsml:controlIncidentInfo or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Well Control Incident</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_WELLCONTROL_INCIDENT_TABLE"/>
			</div>
		</div>
	</xsl:if>
	</xsl:template>
	
	
	<xsl:template name="BUILD_WELLCONTROL_INCIDENT_TABLE">
		<table  id="wellcontrolIncidentTable">
			<xsl:attribute name="class"><xsl:value-of select="$WELLCONTROL_INCIDENT_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead">Time</th>
					<th class="ColHead">Depth <xsl:value-of select="(witsml:controlIncidentInfo/witsml:mdInflow/@uom)[1]"/>MD</th>
					<!--<th class="ColHead">Depth <xsl:value-of select="witsml:controlIncidentInfo/witsml:tvdInflow/@uom"/>TVD</th>-->
					<th class="ColHead">Lost Time (<xsl:value-of select="(witsml:controlIncidentInfo/witsml:eTimLost/@uom)[1]"/>)</th>
					<th class="ColHead">Time for Well Control Regain</th>
					<th class="ColHead">Drilling Fluid Density (<xsl:value-of select="(witsml:controlIncidentInfo/witsml:wtMud/@uom)[1]"/>)</th>
					<th class="ColHead">Pore Pressure (<xsl:value-of select="(witsml:controlIncidentInfo/witsml:porePressure/@uom)[1]"/>)</th>
					<th class="ColHead">Depth to Casing <xsl:value-of select="(witsml:controlIncidentInfo/witsml:mdCsgLast/@uom)[1]"/>MD</th>
					<!--<th class="ColHead">Gained Vol of Fluid (<xsl:value-of select="witsml:controlIncidentInfo/witsml:volMudGained/@uom"/>)</th>-->
					<th class="ColHead">Shut-in Casing Pressure (<xsl:value-of select="(witsml:controlIncidentInfo/witsml:presShutInCasing/@uom)[1]"/>)</th>
					<th class="ColHead">Shut-in Drill Pipe Pressure (<xsl:value-of select="(witsml:controlIncidentInfo/witsml:presShutInDrill/@uom)[1]"/>)</th>
					<th class="ColHead">Incident Class</th>
					<th class="ColHead">Killing Procd</th>
					<th class="ColHead">Formation</th>
				<!--	<th class="ColHead">BHT (<xsl:value-of select="witsml:controlIncidentInfo/witsml:tempBottom/@uom"/>)</th>-->
					<th class="ColHead">Description</th>

				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:controlIncidentInfo">
				   	<xsl:sort select="witsml:dTim" case-order="lower-first"/>

					<tr>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTim"/></xsl:call-template></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdInflow"/></td>
						<!--<td class="ColValue"><xsl:value-of select="witsml:tvdInflow"/></td>-->
						<td class="ColValue"><xsl:value-of select="witsml:eTimLost"/></td>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTimRegained"/></xsl:call-template></td>
						<td class="ColValue"><xsl:value-of select="witsml:wtMud"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:porePressure"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdCsgLast"/></td>
						<!--<td class="ColValue"><xsl:value-of select="witsml:volMudGained"/></td>-->
						<td class="ColValue"><xsl:value-of select="witsml:presShutInCasing"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:presShutInDrill"/></td>
						<td class="ColValueTxt"><xsl:value-of select="witsml:incidentType"/></td>
						<td class="ColValueTxt"><xsl:value-of select="witsml:killingType"/></td>
						<td class="ColValueTxt"><xsl:value-of select="witsml:formation"/></td>
					<!--	<td class="ColValue"><xsl:value-of select="witsml:tempBottom"/></td>-->
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:description"/></td>
			    	</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    		
	
  <xsl:template name="BUILD_GAS_READING_INFO">
  <xsl:if test="witsml:gasReadingInfo or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Gas Reading Information</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_GAS_READING_INFO_TABLE"/>
			</div>
		</div>
	</xsl:if>
	</xsl:template>
	
	
	<xsl:template name="BUILD_GAS_READING_INFO_TABLE">
		<table id="gasreadingInfoTable">
			<xsl:attribute name="class"><xsl:value-of select="$GASREADING_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead">Time</th>
					<th class="ColHead">Class</th>
					<th class="ColHead">Depth to Top <xsl:value-of select="(witsml:gasReadingInfo/witsml:mdTop/@uom)[1]"/>MD</th>
					<th class="ColHead">Depth to Bottom <xsl:value-of select="(witsml:gasReadingInfo/witsml:mdBottom/@uom)[1]"/>MD</th>
					<th class="ColHead">Depth to Top <xsl:value-of select="(witsml:gasReadingInfo/witsml:tvdTop/@uom)[1]"/>TVD</th>
					<th class="ColHead">Depth to Bottom <xsl:value-of select="(witsml:gasReadingInfo/witsml:tvdBottom/@uom)[1]"/>TVD</th>
					
					<th class="ColHead">Highest Gas (<xsl:value-of select="(witsml:gasReadingInfo/witsml:gasHigh/@uom)[1]"/>)</th>
					<th class="ColHead">Lowest Gas (<xsl:value-of select="(witsml:gasReadingInfo/witsml:gasLow/@uom)[1]"/>)</th>
					<th class="ColHead">C1 (<xsl:value-of select="(witsml:gasReadingInfo/witsml:meth/@uom)[1]"/>)</th>
					<th class="ColHead">C2 (<xsl:value-of select="(witsml:gasReadingInfo/witsml:eth/@uom)[1]"/>)</th>
					<th class="ColHead">C3 (<xsl:value-of select="(witsml:gasReadingInfo/witsml:prop/@uom)[1]"/>)</th>
					<th class="ColHead">IC4 (<xsl:value-of select="(witsml:gasReadingInfo/witsml:ibut/@uom)[1]"/>)</th>
					<th class="ColHead">IC5 (<xsl:value-of select="(witsml:gasReadingInfo/witsml:ipent/@uom)[1]"/>)</th>





					
				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:gasReadingInfo">
				    <xsl:sort select="witsml:dTim" case-order="lower-first"/>

					<tr>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTim"/></xsl:call-template></td>
						<td class="ColValueTxt"><xsl:value-of select="witsml:readingType"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdTop"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdBottom"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tvdTop"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tvdBottom"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:gasHigh"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:gasLow"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:meth"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:eth"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:prop"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:ibut"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:ipent"/></td>
					
			    	</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    		
	
	
	<xsl:template name="BUILD_PERFORATION_INFO">
	 <xsl:if test="witsml:perfInfo or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Perforation Information</p>
			</div>
	    </div>
	    <div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_PERFORATION_INFO_TABLE"/>
			</div>
		</div>
	</xsl:if>	
	</xsl:template>
	
	
	<xsl:template name="BUILD_PERFORATION_INFO_TABLE">
		<table id="perforationInfoTable">
			<xsl:attribute name="class"><xsl:value-of select="$PERFORATION_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead">Time of Opening Well Perf</th>
					<th class="ColHead">Time of Closing Well Perf</th>
					<th class="ColHead">Top of Perf <xsl:value-of select="(witsml:perfInfo/witsml:mdTop/@uom)[1]"/>MD</th>
					<th class="ColHead">Bottom of Perf <xsl:value-of select="(witsml:perfInfo/witsml:mdBottom/@uom)[1]"/>MD</th>
					<th class="ColHead">Top of Perf <xsl:value-of select="(witsml:perfInfo/witsml:tvdTop/@uom)[1]"/>TVD</th>
					<th class="ColHead">Bottom of Perf <xsl:value-of select="(witsml:perfInfo/witsml:tvdBottom/@uom)[1]"/>TVD</th>
					
				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:perfInfo">
				    <xsl:sort select="witsml:dTimOpen" case-order="lower-first"/>

					<tr>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTimOpen"/></xsl:call-template></td>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTimClose"/></xsl:call-template></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdTop"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdBottom"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tvdTop"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tvdBottom"/></td>
					
			    	</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    	
	
	<xsl:template name="BUILD_LITHOLOGY_INFO">
	 <xsl:if test="witsml:lithShowInfo or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Lithology Information</p>
			</div>
	    </div>
	    <div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_LITHOLOGY_INFO_TABLE"/>
			</div>
		</div>
	</xsl:if>	
	</xsl:template>
	
	
	<xsl:template name="BUILD_LITHOLOGY_INFO_TABLE">
		<table id="lithologyInfoTable">
			<xsl:attribute name="class"><xsl:value-of select="$LITHOLOGY_INFO_TABLE_CLASS"/></xsl:attribute>
			
			<thead>
				<tr>
					<th class="ColHead">Start Depth <xsl:value-of select="(witsml:lithShowInfo/witsml:mdTop/@uom)[1]"/>MD</th>
					<th class="ColHead">End Depth <xsl:value-of select="(witsml:lithShowInfo/witsml:mdBottom/@uom)[1]"/>MD</th>
					<th class="ColHead">Start Depth <xsl:value-of select="(witsml:lithShowInfo/witsml:tvdTop/@uom)[1]"/>TVD</th>
					<th class="ColHead">End Depth <xsl:value-of select="(witsml:lithShowInfo/witsml:tvdBottom/@uom)[1]"/>TVD</th>
					<th class="ColHead">Shows Description</th>
					<th class="ColHead">Lithology Description</th>
				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:lithShowInfo">
				   	<xsl:sort select="witsml:dTim" case-order="lower-first"/>

					<tr>
						<td class="ColValue"><xsl:value-of select="witsml:mdTop"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdBottom"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tvdTop"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tvdBottom"/></td>
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:show"/></td>
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:lithology"/></td>
			    	</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    	
	
<xsl:template name="BUILD_STRATIGRAPHIC_INFO">
 <xsl:if test="witsml:stratInfo or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Stratigraphic Information</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_STRATIGRAPHIC_INFO_TABLE"/>
			</div>
		
			
		</div>
	</xsl:if>	
	</xsl:template>
	
	
	<xsl:template name="BUILD_STRATIGRAPHIC_INFO_TABLE">
		<table id="stratigraphicInfoTable">
			<xsl:attribute name="class"><xsl:value-of select="$STRATIGRAPHIC_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead">Depth to Top of Formation <xsl:value-of select="(witsml:stratInfo/witsml:mdTop/@uom)[1]"/>MD</th>
					<th class="ColHead">Depth to Top of Formation <xsl:value-of select="(witsml:stratInfo/witsml:tvdTop/@uom)[1]"/>TVD</th>
					<th class="ColHead">Description</th>
				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:stratInfo">
					<xsl:sort select="witsml:mdTop" data-type="number"/>
					<tr>
						<td class="ColValue"><xsl:value-of select="witsml:mdTop"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tvdTop"/></td>
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:description"/></td>
			    	</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    	
	
<xsl:template name="BUILD_FORMATION_TEST">
 <xsl:if test="witsml:formTestInfo or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Formation Test</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_FORMATION_TEST_TABLE"/>
			</div>
		</div>
	</xsl:if>	
	</xsl:template>
	
	
	<xsl:template name="BUILD_FORMATION_TEST_TABLE">
		<table  id="formationtestInfoTable">
			<xsl:attribute name="class"><xsl:value-of select="$FORMATION_TEST_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead">Depth <xsl:value-of select="(witsml:formTestInfo/witsml:md/@uom)[1]"/>MD</th>
					<th class="ColHead">Formation pressure (<xsl:value-of select="(witsml:formTestInfo/witsml:presPore/@uom)[1]"/>)</th>
					<th class="ColHead">Good Seal</th>
					<th class="ColHead">Depth to Sample Point <xsl:value-of select="(witsml:formTestInfo/witsml:mdSample/@uom)[1]"/>MD</th>
					<th class="ColHead">Dominate Fluid Component</th>
					<th class="ColHead">HC Component Density (<xsl:value-of select="(witsml:formTestInfo/witsml:densityHC/@uom)[1]"/>)</th>
					<th class="ColHead">Sample Volume (<xsl:value-of select="(witsml:formTestInfo/witsml:volumeSample/@uom)[1]"/>)</th>
					<th class="ColHead">Description</th>
				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:formTestInfo">
				    <xsl:sort select="witsml:md" data-type="number"/>

					<tr>
						<td class="ColValue"><xsl:value-of select="witsml:md"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:presPore"/></td>
						<td class="ColValueTxt"><xsl:call-template name="OUTPUT_BOOL_VALUE"><xsl:with-param name="VALUE" select="witsml:goodSeal"/></xsl:call-template></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdSample"/></td>
						<td class="ColValueTxt"><xsl:value-of select="witsml:dominateComponent"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:densityHC"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:volumeSample"/></td>
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:description"/></td>
			    	</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    	



<xsl:template name="BUILD_WELLTEST_INFORMATION">
 <xsl:if test="witsml:wellTestInfo or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Welltest Information</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_WELLTEST_INFORMATION_TABLE"/>
			</div>
		</div>
	</xsl:if>	
	</xsl:template>
	
	
	<xsl:template name="BUILD_WELLTEST_INFORMATION_TABLE">
		<table id="wellTestTable">
		    <xsl:attribute name="class"><xsl:value-of select="$WELLTEST_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead">Time</th>
					<th class="ColHead">Test No</th>
					<th class="ColHead">Type</th>
					<th class="ColHead">Depth Top <xsl:value-of select="(witsml:wellTestInfo/witsml:mdTop/@uom)[1]"/>MD</th>
					<th class="ColHead">Depth Bottom <xsl:value-of select="(witsml:wellTestInfo/witsml:mdBottom/@uom)[1]"/>MD</th>
					<th class="ColHead">Choke size (<xsl:value-of select="(witsml:wellTestInfo/witsml:chokeOrificeSize/@uom)[1]"/>)</th>
					<th class="ColHead">Oil rate (<xsl:value-of select="(witsml:wellTestInfo/witsml:flowRateOil/@uom)[1]"/>)</th>
					<th class="ColHead">Gas rate (<xsl:value-of select="(witsml:wellTestInfo/witsml:flowRateGas/@uom)[1]"/>)</th>
					<th class="ColHead">Water rate (<xsl:value-of select="(witsml:wellTestInfo/witsml:flowRateWater/@uom)[1]"/>)</th>
					<th class="ColHead">Shutin press (<xsl:value-of select="(witsml:wellTestInfo/witsml:presShutIn/@uom)[1]"/>)</th>
					<th class="ColHead">Flowing press (<xsl:value-of select="(witsml:wellTestInfo/witsml:presFlowing/@uom)[1]"/>)</th>
					<th class="ColHead">BHP (<xsl:value-of select="(witsml:wellTestInfo/witsml:presBottom/@uom)[1]"/>)</th>
					<th class="ColHead">GoR (<xsl:value-of select="(witsml:wellTestInfo/witsml:gasOilRatio/@uom)[1]"/>)</th>


				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:wellTestInfo">
				    <xsl:sort select="witsml:dTim" case-order="lower-first"/>

					<tr>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTim"/></xsl:call-template></td>
						<td class="ColValue"><xsl:value-of select="witsml:testNumber"/></td>
						<td class="ColValueTxt"><xsl:value-of select="witsml:testType"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdTop"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdBottom"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:chokeOrificeSize"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:flowRateOil"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:flowRateGas"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:flowRateWater"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:presShutIn"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:presFlowing"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:presBottom"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:gasOilRatio"/></td>


						
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    	
	
		
	
	
   <xsl:template name="BUILD_CORE_INFORMATION">
    <xsl:if test="witsml:coreInfo or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Core Information</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				 <xsl:call-template name="BUILD_CORE_INFORMATION_TABLE"/>
			</div>
		</div>
	</xsl:if>	
	</xsl:template>
	
	
	<xsl:template name="BUILD_CORE_INFORMATION_TABLE">
		<table  id="coreinformationInfoTable">
			<xsl:attribute name="class"><xsl:value-of select="$CORE_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead">Core No</th>
					<th class="ColHead">Depth Top <xsl:value-of select="(witsml:coreInfo/witsml:mdTop/@uom)[1]"/>MD</th>
					<th class="ColHead">Depth Bottom <xsl:value-of select="(witsml:coreInfo/witsml:mdBottom/@uom)[1]"/>MD</th>
					<th class="ColHead">Core Length (<xsl:value-of select="(witsml:coreInfo/witsml:lenRecovered/@uom)[1]"/>)</th>
					<th class="ColHead">Recover core (<xsl:value-of select="(witsml:coreInfo/witsml:recoverPc/@uom)[1]"/>)</th>
					<th class="ColHead">Core barrel length (<xsl:value-of select="(witsml:coreInfo/witsml:lenBarrel/@uom)[1]"/>)</th>
					<th class="ColHead">Inner barrel type</th>
					<th class="ColHead">Description</th>

				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:coreInfo">
				    <xsl:sort select="witsml:coreNumber" data-type="number"/>

					<tr>
						<td class="ColValue"><xsl:value-of select="witsml:coreNumber"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdTop"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdBottom"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:lenRecovered"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:recoverPc"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:lenBarrel"/></td>
						<td class="ColValueTxt"><xsl:value-of select="witsml:innerBarrelType"/></td>
						<td class="ColValueTxt"><xsl:value-of select="witsml:coreDescription"/></td>

						
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    	
	
	
	
	
	<xsl:template name="BUILD_LOG_INFORMATION_TABLE">
		<table id="logInfoTable">
		   <xsl:attribute name="class"><xsl:value-of select="$LOG_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead">Run No</th>
					<th class="ColHead">Service Company</th>
					<th class="ColHead">Depth Top <xsl:value-of select="(witsml:logInfo/witsml:mdTop/@uom)[1]"/>MD</th>
					<th class="ColHead">Depth Bottom <xsl:value-of select="(witsml:logInfo/witsml:mdBottom/@uom)[1]"/>MD</th>
					<th class="ColHead">Depth Top <xsl:value-of select="(witsml:logInfo/witsml:tvdTop/@uom)[1]"/>TVD</th>
					<th class="ColHead">Depth Bottom <xsl:value-of select="(witsml:logInfo/witsml:tvdBottom/@uom)[1]"/>TVD</th>
					<th class="ColHead">Tool</th>
					<th class="ColHead">BHST (<xsl:value-of select="(witsml:logInfo/witsml:tempBHST/@uom)[1]"/>)</th>
				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:logInfo">
				   	<xsl:sort select="witsml:runNumber" data-type="number"/>

					<tr>
						<td class="ColValue"><xsl:value-of select="witsml:runNumber"/></td>
						<td class="ColValueTxt"><xsl:value-of select="witsml:serviceCompany"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdTop"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:mdBottom"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tvdTop"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tvdBottom"/></td>
						<td class="ColValueTxt"><xsl:value-of select="witsml:tool"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tempBHST"/></td>
						
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    
	
	<xsl:template name="BUILD_SURVEY_STATION">
	 <xsl:if test="witsml:surveyStation or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Survey Station</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_SURVEY_STATION_TABLE"/>
			</div>
		</div>
	</xsl:if>	
	</xsl:template>
	
	
	<xsl:template name="BUILD_SURVEY_STATION_TABLE">
		<table info="surveystationInfoTable">
			<xsl:attribute name="class"><xsl:value-of select="$SURVEY_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					
					<th class="ColHead">Depth <xsl:value-of select="(witsml:surveyStation/witsml:md/@uom)[1]"/>MD</th>
					<th class="ColHead">Depth <xsl:value-of select="(witsml:surveyStation/witsml:tvd/@uom)[1]"/>TVD</th>
					<th class="ColHead">Inclination (<xsl:value-of select="(witsml:surveyStation/witsml:incl/@uom)[1]"/>)</th>
					<th class="ColHead">Azimuth (<xsl:value-of select="(witsml:surveyStation/witsml:azi/@uom)[1]"/>)</th>
					<th class="ColHead">Comment</th>
				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:surveyStation">
				    <xsl:sort select="witsml:md" data-type="number"/>

					<tr>
						<td class="ColValue"><xsl:value-of select="witsml:md"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tvd"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:incl"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:azi"/></td>
						<td class="ColValueWrappedTxt"><xsl:value-of select="witsml:comment"/></td>
						
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    
    
	<xsl:template name="BUILD_PORE_PRESSURE">
	 <xsl:if test="witsml:porePressure or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Pore Pressure</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_PORE_PRESSURE_TABLE"/>
			</div>
		</div>
	</xsl:if>	
	</xsl:template>
	
	
	<xsl:template name="BUILD_PORE_PRESSURE_TABLE">
		<table id="porepressureInfoTable">
			<xsl:attribute name="class"><xsl:value-of select="$POREPRESSURE_INFO_TABLE_CLASS"/></xsl:attribute>
			<thead>
				<tr>
					<th class="ColHead">Time</th>
					<th class="ColHead">Depth <xsl:value-of select="(witsml:porePressure/witsml:md/@uom)[1]"/>MD</th>
					<th class="ColHead">Depth <xsl:value-of select="(witsml:porePressure/witsml:tvd/@uom)[1]"/>TVD</th>
					<th class="ColHead">Equ Mud Weight (<xsl:value-of select="(witsml:porePressure/witsml:equivalentMudWeight/@uom)[1]"/>)</th>
					<th class="ColHead">Reading</th>
				</tr>
				
			</thead>
			<tbody>
				<xsl:for-each select="witsml:porePressure">
				   <xsl:sort select="witsml:dTim" case-order="lower-first"/>
					<tr>
						<td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTim"/></xsl:call-template></td>
						<td class="ColValue"><xsl:value-of select="witsml:md"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:tvd"/></td>
						<td class="ColValue"><xsl:value-of select="witsml:equivalentMudWeight"/></td>
						<td class="ColValueTxt"><xsl:value-of select="witsml:readingKind"/></td>
						
						
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>    
    
    
    
	
    
    <xsl:template name="BUILD_BIT_RECORD">
    <xsl:if test="witsml:bitRecord or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Bit Record</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_BIT_RECORD_TABLE"/>
			</div>
		</div>
	</xsl:if>	
    </xsl:template>
    
    <xsl:template name="BUILD_BIT_RECORD_TABLE">
		<table  id="bitrecordInfoTable">
				<xsl:attribute name="class"><xsl:value-of select="$BITRECORD_INFO_TABLE_CLASS"/></xsl:attribute>
				 <thead>
					<tr>
					  <th class="ColHead">Run No.</th>
					  <th class="ColHead">Bit Size (<xsl:value-of select="//witsml:bitRecord/witsml:diaBit/@uom[1]"/>)</th>
					  <th class="ColHead">Bit Type</th>
					  <th class="ColHead">IADC Code</th>
					  <th class="ColHead">Manufacturer</th>
					  <th class="ColHead">Hrs Drilled</th>
					  <th class="ColHead">Start mMD</th>
					  <th class="ColHead">End mMD</th>
					  <th class="ColHead">Hole Made (last 24H) <xsl:value-of select="//witsml:bitRun/witsml:mdHoleMadeRun/@uom[1]"/>MD</th>
					  <th class="ColHead">Hours Drilled (last 24H)</th>
					  <th class="ColHead">Form ROP (<xsl:value-of select="//witsml:bitRun/witsml:ropAv/@uom[1]"/>)</th>
					  <th class="ColHead">Total ROP (<xsl:value-of select="//witsml:bitRun/witsml:totRop/@uom[1]"/>)</th>
					  <th class="ColHead">Total Hole Made (<xsl:value-of select="//witsml:bitRun/witsml:mdTotHoleMade/@uom[1]"/>MD)</th>
					  <th class="ColHead">Total Hrs Drilled</th>

					</tr>
				 </thead>
				<tbody>
						    <xsl:for-each select="witsml:bitRecord">
								<tr>
									  <td class="ColValue"><xsl:value-of select="witsml:numBit"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:diaBit"/></td>
									  <td class="ColValueTxt"><xsl:value-of select="witsml:codeMfg"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:codeIADC"/></td>
									  <td class="ColValueTxt"><xsl:value-of select="witsml:manufacturer"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:bitRun/witsml:eTimOpBit"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:bitRun/witsml:mdHoleStart"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:bitRun/witsml:mdHoleStop"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:bitRun/witsml:mdHoleMadeRun"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:bitRun/witsml:hrsDrilledRun"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:bitRun/witsml:ropAv"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:bitRun/witsml:totRop"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:bitRun/witsml:mdTotHoleMade"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:bitRun/witsml:totHrsDrilled"/></td>
								 </tr>
							 </xsl:for-each>
				</tbody>
		</table>
    </xsl:template>    
    
    
    <xsl:template name="BUILD_EQUIPMENT_FAILURE">
     <xsl:if test="witsml:equipFailureInfo or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Equipment Failure Information</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_EQUIPMENT_FAILURE_TABLE"/>
			</div>
		</div>
	</xsl:if>	
    </xsl:template>
    
    <xsl:template name="BUILD_EQUIPMENT_FAILURE_TABLE">
		<table id="equipmentfailureInfoTable">
		        <xsl:attribute name="class"><xsl:value-of select="$EQUIPMENT_FAILURE_INFO_TABLE_CLASS"/></xsl:attribute>
				 <thead>
					<tr>
					  <th class="ColHead">Start time</th>
					  <th class="ColHead">Depth mMD</th>
					  <th class="ColHead">Depth mTVD</th>
					  <th class="ColHead">Sub Equip - Syst Class</th>
					  <th class="ColHead">Operation Downtime (<xsl:value-of select="(witsml:equipFailureInfo/witsml:eTimMissProduction/@uom)[1]"/>)</th>
					  <th class="ColHead">Equipment Repaired</th>
					  <th class="ColHead">Remark</th>
					</tr>
				 </thead>
				<tbody>
						    <xsl:for-each select="witsml:equipFailureInfo">
						    <xsl:sort case-order="lower-first" select="witsml:dTim"/>
								<tr>
									  <td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTim"/></xsl:call-template></td>
									  <td class="ColValue"><xsl:value-of select="witsml:md"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:tvd"/></td>
									  <td class="ColValueTxt"><xsl:value-of select="witsml:equipClass"/></td>
									  <td class="ColValue"><xsl:value-of select="witsml:eTimMissProduction"/></td>
									  <td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTimRepair"/></xsl:call-template></td>
									  <td class="ColValueWrappedTxt"><xsl:value-of select="witsml:description"/></td>
								 </tr>
							 </xsl:for-each>
				</tbody>
		</table>
    </xsl:template>    
    
    <xsl:template name="BUILD_OPERATIONS">
    <xsl:if test="witsml:activity or $INCLUDE_ALL_SECTIONS='1'">
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<p align="left" class="TextHeader">Operations</p>
			</div>
		</div>
		<div class="columns ddr-report-text-data-grid">
			<div class="column">
				<xsl:call-template name="BUILD_OPERATIONS_TABLE"/>
			</div>
		</div>
	</xsl:if>	
    </xsl:template>
    
    
    
    <xsl:template name="BUILD_OPERATIONS_TABLE">
		<table id="operationsInfoTable">
				 <xsl:attribute name="class"><xsl:value-of select="$OPERATIONS_INFO_TABLE_CLASS"/></xsl:attribute>
				 <thead>
					<tr>
					  <th class="ColHead">Start time</th>
					  <th class="ColHead">End time</th>
					  <th class="ColHead">End Depth mMD</th>
					  <th class="ColHead">Main - Sub Activity</th>
					  <th class="ColHead">State</th>
					  <th class="ColHead">Remark</th>
					</tr>
				 </thead>
				<tbody>
						    <xsl:for-each select="witsml:activity">
						    <xsl:sort case-order="lower-first" select="witsml:dTimStart"/>
								<tr>
									  <td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTimStart"/></xsl:call-template></td>
									  <td class="ColValue"><xsl:call-template name="TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTimEnd"/></xsl:call-template></td>
									  <td class="ColValue"><xsl:value-of select="witsml:md"/></td>
									  <td class="ColValueTxt"><xsl:value-of select="witsml:proprietaryCode"/></td>
									  <td class="ColValueTxt"><xsl:value-of select="witsml:state"/></td>
									  <td class="ColValueWrappedTxt"><xsl:value-of select="witsml:comments"/></td>
								 </tr>
							 </xsl:for-each>
				</tbody>
		</table>
    </xsl:template>    
    
    <xsl:template name="WELLBORE_INFO_TABLE_DATA_1">
		<table id="wellboreInfoTable_1">
				<xsl:attribute name="class"><xsl:value-of select="$WELLBORE_INFO_TABLE_CLASS"/></xsl:attribute>
				 
				<tbody>
							<tr>
							  <td class="ColHead">Status:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:versionKind"/></td>
							 </tr>
							<tr>
							  <td class="ColHead">Report creation time:</td>
							  <td class="ColValue"><xsl:call-template name="DATE_AND_TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:createDate"/></xsl:call-template></td>
							</tr>
							<tr>
							  <td class="ColHead">Report number:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:reportNo"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Days Ahead/Behind (+/-):</td>
							  <td class="ColValue"><xsl:value-of select="witsml:wellboreInfo/witsml:daysAhead"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Operator:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:wellboreInfo/witsml:operator"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Rig Name:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:wellboreInfo/witsml:rigAlias[witsml:namingSystem='NPD Name']/witsml:name"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Drilling contractor:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:wellboreInfo/witsml:drillContractor"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Spud Date:</td>
							  <td class="ColValue"><xsl:call-template name="DATE_AND_TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:wellboreInfo/witsml:dTimSpud"/></xsl:call-template></td>
							</tr>
							<tr>
							  <td class="ColHead">Wellbore type:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:typeWellbore"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Elevation RKB-MSL (<xsl:value-of select="witsml:statusInfo/witsml:elevKelly/@uom"/>):</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:elevKelly"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Water depth MSL (<xsl:value-of select="witsml:statusInfo/witsml:waterDepth/@uom"/>):</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:waterDepth"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Tight well:</td>
							  <td class="ColValue"><xsl:call-template name="OUTPUT_BOOL_VALUE"><xsl:with-param name="VALUE" select="witsml:statusInfo/witsml:tightWell"/></xsl:call-template></td>
							</tr>
							<tr>
							  <td class="ColHead">HPHT:</td>
							  <td class="ColValue"><xsl:call-template name="OUTPUT_BOOL_VALUE"><xsl:with-param name="VALUE" select="witsml:statusInfo/witsml:hpht"/></xsl:call-template></td>
							</tr>
							<tr>
							  <td class="ColHead">Temperature (<xsl:value-of select="witsml:statusInfo/witsml:avgTempBH/@uom"/>):</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:avgTempBH"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Pressure (<xsl:value-of select="witsml:statusInfo/witsml:avgPresBH/@uom"/>):</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:avgPresBH"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Date Well Complete:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:wellboreInfo/witsml:dateDrillComplete"/></td>
							</tr>
				  </tbody>
</table>
    </xsl:template>
    
	<xsl:template name="OUTPUT_BOOL_VALUE">
		<xsl:param name="VALUE"/>
		<xsl:choose>
		   <xsl:when test="$VALUE=false()">N</xsl:when>
		    <xsl:when test="$VALUE=true()">Y</xsl:when>
			<xsl:when test="$VALUE='0'">N</xsl:when>
			<xsl:when test="$VALUE='1'">Y</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
    
    <xsl:template name="WELLBORE_INFO_TABLE_DATA_2">
		<table id="wellboreInfoTable_2">
				<xsl:attribute name="class"><xsl:value-of select="$WELLBORE_INFO_TABLE_CLASS"/></xsl:attribute>
				
				<tbody>
							
							<tr>
							  <td class="ColHead">Dist Drilled (<xsl:value-of select="witsml:statusInfo/witsml:distDrill/@uom"/>):</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:distDrill"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Penetration rate (<xsl:value-of select="witsml:statusInfo/witsml:ropCurrent/@uom"/>):</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:ropCurrent"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Hole Dia (<xsl:value-of select="witsml:statusInfo/witsml:diaHole/@uom"/>):</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:diaHole"/></td>
							</tr>
							
							<tr>
							  <td class="ColHead">Pressure Test Type:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:presTestType"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Formation strength (<xsl:value-of select="witsml:statusInfo/witsml:strengthForm/@uom"/>):</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:strengthForm"/></td>
							</tr>
							
							<tr>
							  <td class="ColHead">Dia Last Casing (<xsl:value-of select="witsml:statusInfo/witsml:diaCsgLast/@uom"/>):</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:diaCsgLast"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Depth at Kick Off mMD:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:mdKickoff"/></td>
							 </tr>
							<tr>
							  <td class="ColHead">Depth at Kick Off mTVD:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:tvdKickoff"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Depth mMd:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:md"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Depth mTVD:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:tvd"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Plug Back Depth mMD:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:mdPlugTop"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Depth at formation strength mMD:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:mdStrengthForm"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Depth At Formation Strength mTVD:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:tvdStrengthForm"/></td>
							</tr>
							<tr>
							  <td class="ColHead">Depth At Last Casing mMD:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:mdCsgLast"/></td>
							</tr>
						
							<tr>
							  <td class="ColHead">Depth At Last Casing mTVD:</td>
							  <td class="ColValue"><xsl:value-of select="witsml:statusInfo/witsml:tvdCsgLast"/></td>
							</tr>
							
				  </tbody>
</table>
    </xsl:template>
   
	
	<xsl:template name="BUILD_HEADER">
		
			<div class="columns ddr-report-grid">
				<div class="column" >
					<p align="left" class="DDR-ReportHeader">Daily drilling report</p>
				</div>
			</div>
			<br></br>
			<div class="columns ddr-report-grid">
					<div class="column DDR-SubReportHeader">
					<table width="100%" class="wellbore-report-header-table">
						<tbody>
							<tr>
								<td class="wellboreName"><b>Wellbore: </b><xsl:value-of select="witsml:wellboreAlias[witsml:namingSystem='NPD code']/witsml:name"/></td>
							<!--</tr>
							<tr>-->
								
								<td class="reportingPeriod"><b>Period: </b><xsl:call-template name="DATE_AND_TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTimStart"/></xsl:call-template> - <xsl:call-template name="DATE_AND_TIME_FROM_DATETIME"><xsl:with-param name="DATETIME" select="witsml:dTimEnd"/></xsl:call-template></td>
							</tr>
						</tbody>
					</table>
					</div>
					
				
		    </div>
		
	
	
		
	</xsl:template>
	
	
</xsl:stylesheet>
