<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="html" indent="yes"/>
	<xsl:template match="/">
	<xsl:variable name="INCLUDE_TYPES">ActivityCodeNPD,BitDullCode,BitReasonPulled,casingTypes,cementJobTypes,DominateCopmponentTypeNPD,EquipmentCodeNPD,fluidTypes,MainActivityEvaluation,MudClass,PhaseType,PresTestType,ReadingKind,StateDetailActivity,tubularTypes,WellboreType,WellControlIncidentType,,WellKillingProcedureType,WellNamingSystem,WellTestType</xsl:variable>
		<html>
			<head>
				<title/>
				<style>
				h3 {
					color: #006699;
				}
				
				description p  {
					color: #006699;
				}
				table {
				border-collapse: collapse;
				text-align: left;
				width: 100%;
				}
		th {
			  font: normal 12px/150% Arial, Helvetica, sans-serif;
			    background:linear-gradient(to right, #006699, #00557F);
				background: -webkit-gradient( linear, left top, left bottom, color-stop(0.05, #006699), color-stop(1, #00557F));
				background: -moz-linear-gradient( center top, #006699 5%, #00557F 100%);
				overflow: hidden;
				border: 1px solid #006699;
				color: #ffffff;
				font-size: 15px;
				font-weight: bold;
				font-color: #00496B;
				-webkit-border-radius: 3px;
				-webkit-border-radius: 3px;
				-moz-border-radius: 3px;
				border-radius: 3px;
		}
		table tbody td {
			color: #00496B;
			border-left: 1px solid #E1EEF4;
			font-size: 12px;
			font-weight: normal;
}
}

     
						</style>
			</head>
			<body>
				<br/>
				<br/>
				<hr size="2"/>
				<h3>Overview of valid values for common DDRs parameters</h3>
			   <table>
			              <thead>
								<tr>
									<th>Simple type name</th>
									<th>Description</th>
								</tr>
							</thead>
							<tbody>
								<xsl:for-each select="//xsd:simpleType">
									<xsl:sort select="@name"/>
								
									<xsl:if test="contains($INCLUDE_TYPES,@name)">
										<tr>
											<td><a>
													<xsl:attribute name="href">#<xsl:value-of select="@name"/></xsl:attribute>
													<xsl:value-of select="@name"/>
													</a>
											</td>
											<td><xsl:value-of select="xsd:annotation/xsd:documentation"/></td>
										</tr>
									</xsl:if>
								</xsl:for-each>
								
							</tbody>
						</table>
				<xsl:for-each select="//xsd:simpleType">
									<xsl:sort select="@name"/>
								
									<xsl:if test="contains($INCLUDE_TYPES,@name)">
										<xsl:call-template name="OUTPUT_SIMPLE_TYPE">
												<xsl:with-param name="SIMPLE_NAME" select="@name"/>
										</xsl:call-template>
									</xsl:if>
				</xsl:for-each>
				
				<!--<xsl:call-template name="OUTPUT_SIMPLE_TYPE">
					<xsl:with-param name="SIMPLE_NAME">ActivityCodeNPD</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="OUTPUT_SIMPLE_TYPE">
					<xsl:with-param name="SIMPLE_NAME">EquipmentCodeNPD</xsl:with-param>
				</xsl:call-template>
					<xsl:call-template name="OUTPUT_SIMPLE_TYPE">
					<xsl:with-param name="SIMPLE_NAME">BitReasonPulled</xsl:with-param>
				</xsl:call-template>-->
			</body>
		</html>
	</xsl:template>
	<xsl:template name="OUTPUT_SIMPLE_TYPE">
		<xsl:param name="SIMPLE_NAME"/>
		<br/>
		<hr size="2"/>
		<h3>
			<xsl:attribute name="id"><xsl:value-of select="$SIMPLE_NAME"/></xsl:attribute>
			<xsl:value-of select="$SIMPLE_NAME"/>
		</h3>
		
		<p class="description">
			<b>Description:</b>
			<xsl:value-of select="//xsd:simpleType[@name=$SIMPLE_NAME]/xsd:annotation/xsd:documentation"/>
		</p>
		<div class="datagrid">
		<table>
			<thead>
				<tr>
					<th>Value</th>
					<th>Description</th>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="//xsd:simpleType[@name=$SIMPLE_NAME]/xsd:restriction/xsd:enumeration">
				   <xsl:sort select="@value"/>
					<tr>
						<td width="20%">
							<xsl:value-of select="@value"/>
						</td>
						<td width="80%">
							<xsl:value-of select="xsd:annotation/xsd:documentation"/>
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		</div>
	</xsl:template>
</xsl:stylesheet>
