/*
 * Decompiled with CFR 0.152.
 */
package com.epim.ep.standards;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class XSDDateHelper {
    public static String DateTime2LocalTime(String dateStr, String returnFormat) {
        ZonedDateTime dTimZoneLocal;
        String result = dateStr;
        try {
            ZonedDateTime dTimZone = ZonedDateTime.parse(dateStr, DateTimeFormatter.ISO_DATE_TIME);
            dTimZoneLocal = dTimZone.withZoneSameInstant(ZoneId.systemDefault());
        }
        catch (DateTimeException e) {
            LocalDateTime dt = LocalDateTime.parse(dateStr, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            dTimZoneLocal = dt.atZone(ZoneId.systemDefault());
        }
        result = XSDDateHelper.FormatDate2String(dTimZoneLocal, returnFormat);
        return result;
    }

    public static ZonedDateTime parseToZonedDateTime(String date, String dateFormat) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
        ZonedDateTime zonedDateTime = null;
        try {
            zonedDateTime = ZonedDateTime.parse(date, formatter);
        }
        catch (DateTimeException e) {
            LocalDateTime dt = LocalDateTime.parse(date, formatter);
            zonedDateTime = dt.atZone(ZoneId.systemDefault());
        }
        return zonedDateTime;
    }

    public static String FormatDate2String(ZonedDateTime dObj, String format) {
        return DateTimeFormatter.ofPattern(format).format(dObj);
    }

    public static String FormatDateStr2Str(String dateStr, String inFormat, String outFormat) {
        String resultStr = "";
        SimpleDateFormat in = new SimpleDateFormat(inFormat);
        SimpleDateFormat out = new SimpleDateFormat(outFormat);
        try {
            Date dObjIn = in.parse(dateStr);
            resultStr = out.format(dObjIn);
        }
        catch (ParseException e) {
            resultStr = "INVALID INCOMING DATE, cannot parse " + dateStr + " using format:" + inFormat;
        }
        return resultStr;
    }
}

